/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.qualityreview;

import java.util.List;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.web.support.json.adapter.DataTableJsonAdapter;
import org.egov.infra.web.support.ui.DataTable;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.entity.contract.QualityReviewSearchRequest;
import org.egov.pgr.report.entity.contract.QualityReviewAdaptor;
import org.egov.pgr.service.ComplaintTypeService;
import org.egov.pgr.service.QualityReviewService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/qualityreview/search"})
public class QualityReviewSearchController {
    private static final String QUALITYREVIEWSEARCH = "qualityreview-search";
    @Autowired
    private ComplaintTypeService complaintTypeService;
    @Autowired
    private QualityReviewService qualityReviewService;
    @Autowired
    private QualityReviewAdaptor qualityReviewAdaptor;
    @Autowired
    private BoundaryService boundaryService;

    @ModelAttribute(value="complaintType")
    public List<ComplaintType> categories() {
        return this.complaintTypeService.findAll();
    }

    @ModelAttribute(value="ward")
    public List<Boundary> boundary() {
        return this.boundaryService.getBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "Administration");
    }

    @ModelAttribute
    public QualityReviewSearchRequest qualityReviewSearchRequest() {
        return new QualityReviewSearchRequest();
    }

    @GetMapping
    public String showQualityReviewSearchForm() {
        return QUALITYREVIEWSEARCH;
    }

    @GetMapping(value={"/"}, produces={"text/plain"})
    @ResponseBody
    public String searchGrievanceForQualityReview(QualityReviewSearchRequest qualityReviewSearchRequest) {
        return new DataTable(this.qualityReviewService.getGrievancesForReview(qualityReviewSearchRequest), (long)qualityReviewSearchRequest.draw()).toJson((DataTableJsonAdapter)this.qualityReviewAdaptor);
    }
}

