/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.qualityreview;

import java.util.List;
import javax.validation.Valid;
import org.egov.pgr.entity.Complaint;
import org.egov.pgr.entity.FeedbackReason;
import org.egov.pgr.entity.QualityReview;
import org.egov.pgr.service.ComplaintHistoryService;
import org.egov.pgr.service.ComplaintService;
import org.egov.pgr.service.FeedbackReasonService;
import org.egov.pgr.service.QualityReviewService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/complaint/qualityreview/{crn}"})
public class QualityReviewController {
    private static final String QUALITYREVIEW = "qualityreview";
    @Autowired
    private ComplaintService complaintService;
    @Autowired
    private ComplaintHistoryService complaintHistoryService;
    @Autowired
    private QualityReviewService qualityReviewService;
    @Autowired
    private FeedbackReasonService feedbackReasonService;

    @ModelAttribute
    public QualityReview qualityReview(@PathVariable String crn) {
        return this.qualityReviewService.getExistingQualityReviewByCRN(crn).orElse(new QualityReview());
    }

    @ModelAttribute(value="feedbackReasons")
    public List<FeedbackReason> feedbackReasons() {
        return this.feedbackReasonService.getAllFeedbackReason();
    }

    @GetMapping
    public String showQualityReviewForm(@PathVariable String crn, @ModelAttribute QualityReview qualityReview, Model model) {
        Complaint complaint = this.complaintService.getComplaintByCRN(crn);
        List historyTable = this.complaintHistoryService.getHistory(complaint);
        model.addAttribute("complaintHistory", (Object)historyTable);
        model.addAttribute("complaint", (Object)complaint);
        return QUALITYREVIEW;
    }

    @PostMapping
    public String createQualityReview(@PathVariable String crn, @Valid @ModelAttribute QualityReview qualityReview, BindingResult bindingResult, RedirectAttributes responseAttrbs) {
        if (bindingResult.hasErrors()) {
            return "/complaint/qualityreview/" + crn;
        }
        if (qualityReview.isExisting()) {
            this.qualityReviewService.updateQualityReview(qualityReview);
        } else {
            this.qualityReviewService.createQualityReview(qualityReview);
        }
        responseAttrbs.addFlashAttribute("message", (Object)"msg.feedback.success");
        return "redirect:/qualityreview/search";
    }
}

