/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.masters.type;

import org.egov.infra.web.support.search.DataTableSearchRequest;
import org.egov.infra.web.support.ui.DataTable;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.entity.contract.ComplaintTypeAdaptor;
import org.egov.pgr.service.ComplaintTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/complainttype/view"})
public class ViewComplaintTypeController {
    @Autowired
    private ComplaintTypeService complaintTypeService;

    @GetMapping
    public String viewComplaintTypeForm() {
        return "view-complaintType";
    }

    @GetMapping(value={"/"}, produces={"text/plain"})
    @ResponseBody
    public String viewComplaintType(DataTableSearchRequest request) {
        return new DataTable(this.complaintTypeService.getComplaintType(request), (long)request.draw()).toJson(ComplaintTypeAdaptor.class);
    }

    @GetMapping(value={"/{code}"})
    public String viewComplaintTypeDetails(@PathVariable String code, @ModelAttribute ComplaintType complaintType, Model model) {
        model.addAttribute("complaintType", (Object)this.complaintTypeService.findByCode(code));
        return "complainttype-success";
    }
}

