/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.masters.type;

import java.util.List;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.service.ComplaintTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/complainttype/search"})
public class SearchComplaintTypeController {
    @Autowired
    private ComplaintTypeService complaintTypeService;

    @ModelAttribute
    public ComplaintType complaintTypeModel() {
        return new ComplaintType();
    }

    @GetMapping
    public String searchComplaintTypesForm(Model model) {
        model.addAttribute("complaintTypes", (Object)this.complaintTypeService.findAll());
        return "complaintType-list";
    }

    @PostMapping
    public String goToUpdateComplaintTypeForm(ComplaintType complaintType, BindingResult errors) {
        if (errors.hasErrors()) {
            return "complaint-type";
        }
        return "redirect:/complainttype/update/" + complaintType.getName();
    }

    @GetMapping(value={"by-department"})
    @ResponseBody
    public List<ComplaintType> getComplaitnTypesByDepartment(@RequestParam Long departmentId) {
        return this.complaintTypeService.getComplaintTypeByDepartmentId(departmentId);
    }
}

