/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.masters.type;

import java.util.List;
import javax.validation.Valid;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.entity.ComplaintTypeCategory;
import org.egov.pgr.service.ComplaintTypeCategoryService;
import org.egov.pgr.service.ComplaintTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/complainttype/create"})
public class CreateComplaintTypeController {
    @Autowired
    private ComplaintTypeCategoryService complaintTypeCategoryService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private ComplaintTypeService complaintTypeService;

    @ModelAttribute(value="categories")
    public List<ComplaintTypeCategory> categories() {
        return this.complaintTypeCategoryService.findAll();
    }

    @ModelAttribute(value="departments")
    public List<Department> departments() {
        return this.departmentService.getAllDepartments();
    }

    @ModelAttribute
    public ComplaintType complaintTypeModel() {
        return new ComplaintType();
    }

    @GetMapping
    public String createComplaintTypeForm() {
        return "complaint-type";
    }

    @PostMapping
    public String createComplaintType(@Valid ComplaintType complaintType, BindingResult errors, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            return "complaint-type";
        }
        this.complaintTypeService.createComplaintType(complaintType);
        redirectAttrs.addFlashAttribute("complaintType", (Object)complaintType);
        redirectAttrs.addFlashAttribute("message", (Object)"msg.comp.type.success");
        return "redirect:/complainttype/view/" + complaintType.getCode();
    }
}

