/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.masters.router;

import java.util.List;
import javax.validation.Valid;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.pgr.entity.ComplaintRouter;
import org.egov.pgr.service.ComplaintRouterService;
import org.egov.pgr.web.controller.masters.router.ComplaintRouterValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/complaint/router"})
class UpdateRouterController {
    private static final String ROUTER_UPDATE = "router-updateSearch";
    private static final String COMPLAINT_ROUTER = "complaintRouter";
    private static final String MESSAGE = "message";
    @Autowired
    private BoundaryTypeService boundaryTypeService;
    @Autowired
    private ComplaintRouterService complaintRouterService;
    @Autowired
    private ComplaintRouterValidator complaintRouterValidator;

    UpdateRouterController() {
    }

    @ModelAttribute(value="boundaryTypes")
    public List<BoundaryType> boundaryTypes() {
        return this.boundaryTypeService.getBoundaryTypeByHierarchyTypeName("ADMINISTRATION");
    }

    @ModelAttribute
    public ComplaintRouter complaintRouter(@PathVariable Long id) {
        return this.complaintRouterService.getRouterById(id);
    }

    @GetMapping(value={"update/{id}"})
    public String updateRouterForm() {
        return ROUTER_UPDATE;
    }

    @GetMapping(value={"view/{id}"})
    public String viewRouterForm() {
        return "router-view";
    }

    @PostMapping(value={"update/{id}"})
    public String update(@Valid ComplaintRouter complaintRouter, BindingResult errors, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            return ROUTER_UPDATE;
        }
        this.complaintRouterService.updateComplaintRouter(complaintRouter);
        redirectAttrs.addFlashAttribute(COMPLAINT_ROUTER, (Object)complaintRouter);
        redirectAttrs.addFlashAttribute(MESSAGE, (Object)"msg.router.update.success");
        return "redirect:/complaint/router/view/" + complaintRouter.getId();
    }

    @PostMapping(value={"delete/{id}"})
    public String delete(@Valid ComplaintRouter complaintRouter, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        this.complaintRouterValidator.validate((Object)complaintRouter, (Errors)errors);
        if (errors.hasErrors()) {
            model.addAttribute(MESSAGE, (Object)"msg.router.cannot.delete");
            return ROUTER_UPDATE;
        }
        this.complaintRouterService.deleteComplaintRouter(complaintRouter);
        redirectAttrs.addFlashAttribute(MESSAGE, (Object)"msg.router.del.success");
        return "redirect:/complaint/router/search/update";
    }
}

