/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.masters.router;

import java.util.List;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.infra.reporting.engine.ReportDisposition;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.util.ReportUtil;
import org.egov.infra.utils.StringUtils;
import org.egov.infra.web.support.ui.DataTable;
import org.egov.pgr.entity.ComplaintRouter;
import org.egov.pgr.entity.contract.ComplaintRouterResponseAdaptor;
import org.egov.pgr.entity.contract.ComplaintRouterSearchRequest;
import org.egov.pgr.service.ComplaintRouterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/complaint/router/search"})
public class SearchRoutingController {
    private static final String ADMINISTRATION = "ADMINISTRATION";
    private static final String ROUTER_SEARCH = "router-search";
    @Autowired
    private BoundaryTypeService boundaryTypeService;
    @Autowired
    private ComplaintRouterService complaintRouterService;

    @ModelAttribute
    public ComplaintRouter complaintRouter() {
        return new ComplaintRouter();
    }

    @ModelAttribute(value="boundaryTypes")
    public List<BoundaryType> boundaryTypes() {
        return this.boundaryTypeService.getBoundaryTypeByHierarchyTypeName(ADMINISTRATION);
    }

    @GetMapping(value={"update"})
    public String searchRouterUpdateForm() {
        return ROUTER_SEARCH;
    }

    @GetMapping(value={"view"})
    public String searchRouterViewForm(Model model) {
        model.addAttribute("mode", (Object)"view");
        return ROUTER_SEARCH;
    }

    @GetMapping(produces={"text/plain"})
    @ResponseBody
    public String search(ComplaintRouterSearchRequest routerSearchRequest) {
        return new DataTable(this.complaintRouterService.getComplaintRouter(routerSearchRequest), (long)routerSearchRequest.draw()).toJson(ComplaintRouterResponseAdaptor.class);
    }

    @GetMapping(value={"download"})
    @ResponseBody
    public ResponseEntity<InputStreamResource> downloadRouterView(ComplaintRouterSearchRequest reportCriteria) {
        ReportOutput reportOutput = this.complaintRouterService.generateRouterReport(reportCriteria);
        reportOutput.setReportName(StringUtils.appendTimestamp((String)"pgr_routerView"));
        reportOutput.setReportDisposition(ReportDisposition.ATTACHMENT);
        return ReportUtil.reportAsResponseEntity((ReportOutput)reportOutput);
    }
}

