/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.masters.router;

import java.util.List;
import javax.validation.Valid;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.pgr.entity.ComplaintRouter;
import org.egov.pgr.service.ComplaintRouterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/complaint/router/create"})
class CreateRouterController {
    private static final String CREATE_ROUTER = "router-create";
    @Autowired
    private BoundaryTypeService boundaryTypeService;
    @Autowired
    private ComplaintRouterService complaintRouterService;

    CreateRouterController() {
    }

    @ModelAttribute(value="boundaryTypes")
    public List<BoundaryType> boundaryTypes() {
        return this.boundaryTypeService.getBoundaryTypeByHierarchyTypeName("ADMINISTRATION");
    }

    @ModelAttribute
    public ComplaintRouter complaintRouter() {
        return new ComplaintRouter();
    }

    @GetMapping
    public String createRouterForm() {
        return CREATE_ROUTER;
    }

    @PostMapping
    public String create(@Valid ComplaintRouter complaintRouter, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors() || this.complaintRouterService.validateRouter(complaintRouter).booleanValue()) {
            model.addAttribute("warning", (Object)"router.exists");
            return CREATE_ROUTER;
        }
        this.complaintRouterService.createComplaintRouter(complaintRouter);
        redirectAttrs.addFlashAttribute("complaintRouter", (Object)complaintRouter);
        redirectAttrs.addFlashAttribute("message", (Object)"msg.router.success");
        return "redirect:/complaint/router/view/" + complaintRouter.getId();
    }
}

