/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.masters.router;

import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.infra.utils.JsonUtils;
import org.egov.pgr.entity.ComplaintRouter;
import org.egov.pgr.entity.ComplaintTypeCategory;
import org.egov.pgr.entity.contract.BulkRouterGenerator;
import org.egov.pgr.entity.contract.ComplaintRouterAdaptor;
import org.egov.pgr.service.ComplaintRouterService;
import org.egov.pgr.service.ComplaintTypeCategoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/complaint/bulkrouter"})
public class BulkRouterGenerationController {
    @Autowired
    private ComplaintRouterService complaintRouterService;
    @Autowired
    private BoundaryTypeService boundaryTypeService;
    @Autowired
    private ComplaintTypeCategoryService complaintTypeCategoryService;

    @ModelAttribute(value="boundaryTypes")
    public List<BoundaryType> boundaryTypes() {
        return this.boundaryTypeService.getBoundaryTypeByHierarchyTypeName("ADMINISTRATION");
    }

    @ModelAttribute(value="categories")
    public List<ComplaintTypeCategory> categories() {
        return this.complaintTypeCategoryService.findAll();
    }

    @ModelAttribute
    public BulkRouterGenerator bulkRouterGenerator() {
        return new BulkRouterGenerator();
    }

    @GetMapping
    public String complaintBulkRouterForm() {
        return "bulkrouter";
    }

    @GetMapping(value={"/"}, produces={"text/plain"})
    @ResponseBody
    public String search(BulkRouterGenerator bulkRouterGenerator) {
        return "{ \"data\":" + JsonUtils.toJSON((Collection)this.complaintRouterService.getRoutersByComplaintTypeBoundary(bulkRouterGenerator.getComplaintTypes(), bulkRouterGenerator.getBoundaries()), ComplaintRouter.class, ComplaintRouterAdaptor.class) + "}";
    }

    @PostMapping(value={"create"})
    public String createComplaintBulkRouter(@Valid BulkRouterGenerator bulkRouterGenerator, RedirectAttributes redirectAttrs, BindingResult errors, Model model) {
        if (errors.hasErrors()) {
            model.addAttribute("message", (Object)"router.unble.to.save");
            return "bulkrouter";
        }
        this.complaintRouterService.createBulkRouter(bulkRouterGenerator);
        redirectAttrs.addFlashAttribute("message", (Object)"msg.bulkrouter.success");
        return "redirect:/complaint/bulkrouter";
    }
}

