/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.masters.escalation;

import java.util.List;
import org.egov.pgr.entity.contract.EscalationForm;
import org.egov.pgr.service.ComplaintEscalationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/complaint/escalationtime"})
public class SearchEscalationTimeController {
    private static final String ESCALATION_TIME_SEARCH = "escalationtime-search";
    @Autowired
    private ComplaintEscalationService escalationService;

    @ModelAttribute
    public EscalationForm escalationForm() {
        return new EscalationForm();
    }

    @GetMapping
    public String searchForm() {
        return ESCALATION_TIME_SEARCH;
    }

    @PostMapping
    public String searchEscalationTimeForm(EscalationForm escalationForm, Model model) {
        List escalationList = this.escalationService.findAllBycomplaintTypeId(escalationForm.getComplaintType().getId());
        if (!escalationList.isEmpty() && escalationList != null) {
            escalationForm.setEscalationList(escalationList);
            model.addAttribute("mode", (Object)"dataFound");
        } else {
            model.addAttribute("mode", (Object)"noDataFound");
        }
        return ESCALATION_TIME_SEARCH;
    }

    @PostMapping(value={"update"})
    public String updateEscalationTime(EscalationForm escalationForm, RedirectAttributes redirectAtt) {
        this.escalationService.updateEscalationTime(escalationForm);
        redirectAtt.addFlashAttribute("message", (Object)"msg.escalate.time.success");
        return "redirect:/complaint/escalationtime";
    }
}

