/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.masters.escalation;

import java.util.ArrayList;
import java.util.List;
import org.egov.commons.ObjectType;
import org.egov.commons.service.ObjectTypeService;
import org.egov.eis.entity.PositionHierarchy;
import org.egov.eis.service.PositionHierarchyService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.entity.contract.EscalationForm;
import org.egov.pgr.service.ComplaintEscalationService;
import org.egov.pgr.service.ComplaintTypeService;
import org.egov.pims.commons.Position;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/complaint/escalation/search"})
public class SearchEscalationController {
    private static final String ESCALATIONSEARCHVIEW = "escalation-search";
    private static final String MESSAGE = "message";
    @Autowired
    private ComplaintTypeService complaintTypeService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private ObjectTypeService objectTypeService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private PositionHierarchyService positionHierarchyService;
    @Autowired
    private ComplaintEscalationService complaintEscalationService;

    @ModelAttribute
    public EscalationForm escalationForm() {
        return new EscalationForm();
    }

    @ModelAttribute(value="complaintTypes")
    public List<ComplaintType> complaintTypes() {
        return this.complaintTypeService.findActiveComplaintTypes();
    }

    @ModelAttribute(value="positionMasterList")
    public List<Position> positionMasterList() {
        return this.positionMasterService.getAllPositions();
    }

    @GetMapping
    public String searchEscalationForm() {
        return ESCALATIONSEARCHVIEW;
    }

    @PostMapping
    public String searchForm(EscalationForm escalationForm, Model model) {
        if (escalationForm.getPosition() != null) {
            ObjectType objectType = this.objectTypeService.getObjectTypeByName("Complaint");
            ArrayList<PositionHierarchy> positionHeirarchyList = this.positionHierarchyService.getPositionHeirarchyByFromPositionAndObjectType(escalationForm.getPosition().getId(), objectType.getId());
            if (!positionHeirarchyList.isEmpty()) {
                escalationForm.setPositionHierarchyList((List)positionHeirarchyList);
                model.addAttribute("mode", (Object)"dataFound");
            } else {
                positionHeirarchyList = new ArrayList<PositionHierarchy>();
                PositionHierarchy posHierarchy = new PositionHierarchy();
                posHierarchy.setFromPosition(this.positionMasterService.getPositionById(escalationForm.getPosition().getId()));
                posHierarchy.setObjectType(objectType);
                posHierarchy.setObjectSubType("");
                positionHeirarchyList.add(posHierarchy);
                escalationForm.setPositionHierarchyList(positionHeirarchyList);
                model.addAttribute("mode", (Object)"noDataFound");
            }
        }
        model.addAttribute("approvalDepartmentList", (Object)this.departmentService.getAllDepartments());
        return ESCALATIONSEARCHVIEW;
    }

    @PostMapping(value={"update/{id}"})
    public String saveEscalationForm(@PathVariable Long id, EscalationForm escalationForm, Model model, RedirectAttributes redirectAttrs) {
        if (id == null) {
            model.addAttribute(MESSAGE, (Object)"escalation.pos.required");
            return ESCALATIONSEARCHVIEW;
        }
        this.complaintEscalationService.updateEscalation(id, escalationForm);
        redirectAttrs.addFlashAttribute("positionName", (Object)escalationForm.getPosition().getName());
        redirectAttrs.addFlashAttribute(MESSAGE, (Object)"msg.escaltion.success");
        return "redirect:/complaint/escalation/search";
    }
}

