/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.masters.escalation;

import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.egov.infra.utils.JsonUtils;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.entity.contract.BulkEscalationGenerator;
import org.egov.pgr.entity.contract.EscalationHelper;
import org.egov.pgr.entity.contract.EscalationHelperAdaptor;
import org.egov.pgr.service.ComplaintEscalationService;
import org.egov.pgr.service.ComplaintTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/complaint/bulkescalation"})
public class BulkEscalationController {
    @Autowired
    private ComplaintEscalationService escalationService;
    @Autowired
    private ComplaintTypeService complaintTypeService;
    @Autowired
    private ComplaintEscalationService complaintEscalationService;

    @ModelAttribute(value="complainttypes")
    public List<ComplaintType> complaintTypes() {
        return this.complaintTypeService.findActiveComplaintTypes();
    }

    @ModelAttribute
    public BulkEscalationGenerator bulkEscalationGenerator() {
        return new BulkEscalationGenerator();
    }

    @GetMapping
    public String bulkEscalationForm() {
        return "bulkescalation";
    }

    @GetMapping(value={"/"}, produces={"text/plain"})
    @ResponseBody
    public String searchBulkEscalation(BulkEscalationGenerator bulkEscalationGenerator) {
        List positionHierarchies = this.escalationService.getEscalationObjByComplaintTypeFromPosition(bulkEscalationGenerator.getComplaintTypes(), bulkEscalationGenerator.getFromPosition());
        return "{ \"data\":" + JsonUtils.toJSON((Collection)this.complaintEscalationService.getEscalationDetailByPositionHierarchy(positionHierarchies), EscalationHelper.class, EscalationHelperAdaptor.class) + "}";
    }

    @PostMapping(value={"update"})
    public String updateBulkEscalation(@Valid BulkEscalationGenerator bulkEscalationGenerator, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (errors.hasErrors()) {
            model.addAttribute("message", (Object)"bulkescalation.unble.to.save");
            return "bulkescalation";
        }
        this.complaintEscalationService.updateBulkEscalation(bulkEscalationGenerator);
        redirectAttrs.addFlashAttribute("message", (Object)"msg.bulkescalation.success");
        return "redirect:/complaint/bulkescalation";
    }
}

