/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.masters.category;

import javax.validation.Valid;
import org.egov.pgr.entity.ComplaintTypeCategory;
import org.egov.pgr.service.ComplaintTypeCategoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/complaint/category/update/{categoryName}"})
public class UpdateComplaintTypeCategoryController {
    @Autowired
    private ComplaintTypeCategoryService complaintTypeCategoryService;

    @ModelAttribute
    public ComplaintTypeCategory complaintTypeCategory(@PathVariable String categoryName) {
        return this.complaintTypeCategoryService.findByName(categoryName);
    }

    @GetMapping
    public String updateComplaintTypeCategoryForm(@PathVariable String categoryName, ComplaintTypeCategory complaintTypeCategory, Model model) {
        if (complaintTypeCategory == null) {
            model.addAttribute("error", (Object)"grievance.category.not.found");
            model.addAttribute("categoryname", (Object)categoryName);
            return "redirect:/complaint/category/search";
        }
        return "complainttype-category-update";
    }

    @PostMapping
    public String updateComplaintTypeCategory(@Valid ComplaintTypeCategory complaintTypeCategory, BindingResult error, RedirectAttributes redirectAttrs) {
        if (error.hasErrors()) {
            return "complainttype-category-update";
        }
        this.complaintTypeCategoryService.createComplaintTypeCategory(complaintTypeCategory);
        redirectAttrs.addFlashAttribute("message", (Object)"msg.comp.type.catgory.update.success");
        return "redirect:/complaint/category/update/" + complaintTypeCategory.getName();
    }
}

