/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.dashboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.egov.infra.web.support.ui.DataTable;
import org.egov.pgr.dashboard.service.DashboardService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/dashboard"})
public class DashboardController {
    @Autowired
    private DashboardService dashboardService;

    @RequestMapping(value={"/home"})
    public String home() {
        return "dashboard/home";
    }

    @RequestMapping(value={"/reg-resolution-trend"}, produces={"application/json"})
    @ResponseBody
    public List<Collection<Integer>> registrationResolutionTrend() {
        ArrayList<Collection<Integer>> regResTrendData = new ArrayList<Collection<Integer>>();
        regResTrendData.add(this.dashboardService.getComplaintRegistrationTrend());
        regResTrendData.add(this.dashboardService.getComplaintResolutionTrend());
        return regResTrendData;
    }

    @RequestMapping(value={"/monthly-aggregate"}, produces={"application/json"})
    @ResponseBody
    public List<Map<String, Object>> monthlyAggregate() {
        return this.dashboardService.getMonthlyAggregate();
    }

    @RequestMapping(value={"/typewise-aggregate"}, produces={"application/json"})
    @ResponseBody
    public List<Map<String, Object>> complaintTypewiseAggregate() {
        return this.dashboardService.getCompTypewiseAggregate();
    }

    @RequestMapping(value={"/ageing/{ward}"}, produces={"application/json"})
    @ResponseBody
    public List<List<Object>> wardwiseAgeing(@PathVariable String ward) {
        return this.dashboardService.getAgeingByWard(ward);
    }

    @RequestMapping(value={"/wardwise-performance"}, produces={"application/json"})
    @ResponseBody
    public List<Object> wardwisePerformance() {
        List wardwisePerformance = this.dashboardService.getWardwisePerformance();
        LinkedList<Object> performanceData = new LinkedList<Object>();
        performanceData.add(wardwisePerformance.get(0));
        int size = wardwisePerformance.size();
        performanceData.add(new DataTable(0L, (long)size, (long)size, (long)size, (List)wardwisePerformance.get(0)));
        performanceData.add(wardwisePerformance.get(1));
        return performanceData;
    }

    @RequestMapping(value={"/sla/{charttype}"}, produces={"application/json"})
    @ResponseBody
    public List complaintSLA(@PathVariable String charttype) {
        if ("pie".equals(charttype)) {
            return this.dashboardService.getComplaintSLA();
        }
        if ("gis".equals(charttype)) {
            return this.dashboardService.getOpenComplaintSLA();
        }
        return Collections.emptyList();
    }

    @RequestMapping(value={"/wardwise-complaint-by-type/{typeid}"}, produces={"application/json"})
    @ResponseBody
    public List<Map<String, Object>> wardwiseComplaintByComplaintType(@PathVariable Long typeid, @RequestParam String color) {
        return this.dashboardService.getWardwiseComplaintByComplaintType(typeid, color);
    }

    @RequestMapping(value={"/top-complaints"})
    @ResponseBody
    public Map<String, Object> topComplaints() {
        return this.dashboardService.topComplaints();
    }

    @RequestMapping(value={"/gis-analysis"})
    @ResponseBody
    public Map<String, List<Map<String, Object>>> gisAnalysis() {
        return this.dashboardService.getGISWardWiseAnalysis();
    }
}

