/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.complaint.citizen;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.ValidationException;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.admin.master.entity.CrossHierarchy;
import org.egov.infra.security.utils.captcha.CaptchaUtils;
import org.egov.pgr.entity.Complaint;
import org.egov.pgr.web.controller.complaint.GenericComplaintController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/complaint/citizen"})
public class CitizenComplaintRegistrationController
extends GenericComplaintController {
    private static final String CITIZEN_COMPLAINT_REGISTRATION_FORM = "complaint/citizen/registration-form";
    private static final String ANONYMOUS_COMPLAINT_REGISTRATION_FORM = "complaint/citizen/anonymous-registration-form";
    private static final String LOCATION = "location";
    @Autowired
    private CaptchaUtils captchaUtils;

    @RequestMapping(value={"show-reg-form"}, method={RequestMethod.GET})
    public String showComplaintRegistrationForm(@ModelAttribute Complaint complaint) {
        this.setReceivingMode(complaint, "WEBSITE");
        return CITIZEN_COMPLAINT_REGISTRATION_FORM;
    }

    @RequestMapping(value={"anonymous/show-reg-form"}, method={RequestMethod.GET})
    public String showAnonymousComplaintRegistrationForm(@ModelAttribute Complaint complaint, @RequestParam(required=false) String source) {
        this.setReceivingMode(complaint, StringUtils.isBlank((CharSequence)source) ? "WEBSITE" : source);
        return ANONYMOUS_COMPLAINT_REGISTRATION_FORM;
    }

    @RequestMapping(value={"register"}, method={RequestMethod.POST})
    public String registerComplaint(@Valid @ModelAttribute Complaint complaint, BindingResult resultBinder, RedirectAttributes redirectAttributes, @RequestParam(value="files") MultipartFile[] files, Model model) {
        if (complaint.getCrossHierarchyId() != null) {
            CrossHierarchy crosshierarchy = this.crossHierarchyService.findById(complaint.getCrossHierarchyId());
            complaint.setLocation(crosshierarchy.getParent());
            complaint.setChildLocation(crosshierarchy.getChild());
        }
        if (complaint.getLocation() == null && (complaint.getLat() == 0.0 || complaint.getLng() == 0.0)) {
            resultBinder.rejectValue(LOCATION, "location.required");
        }
        if (resultBinder.hasErrors()) {
            if (complaint.getCrossHierarchyId() != null) {
                model.addAttribute("crossHierarchyLocation", (Object)(complaint.getChildLocation().getName() + " - " + complaint.getLocation().getName()));
            }
            return CITIZEN_COMPLAINT_REGISTRATION_FORM;
        }
        try {
            complaint.setSupportDocs(this.fileStoreUtils.addToFileStore(files, "PGR", true));
            this.complaintService.createComplaint(complaint);
        }
        catch (ValidationException e) {
            resultBinder.rejectValue(LOCATION, e.getMessage());
            return CITIZEN_COMPLAINT_REGISTRATION_FORM;
        }
        redirectAttributes.addFlashAttribute("complaint", (Object)complaint);
        return "redirect:/complaint/reg-success/" + complaint.getCrn();
    }

    @RequestMapping(value={"anonymous/register"}, method={RequestMethod.POST})
    public String registerComplaintAnonymous(@Valid @ModelAttribute Complaint complaint, BindingResult resultBinder, RedirectAttributes redirectAttributes, HttpServletRequest request, @RequestParam(value="files") MultipartFile[] files, Model model) {
        if (!this.captchaUtils.captchaIsValid(request)) {
            resultBinder.reject("captcha.not.valid");
        }
        if (StringUtils.isBlank((CharSequence)complaint.getComplainant().getEmail()) && StringUtils.isBlank((CharSequence)complaint.getComplainant().getMobile())) {
            resultBinder.rejectValue("complainant.email", "email.or.mobile.ismandatory");
        }
        if (StringUtils.isBlank((CharSequence)complaint.getComplainant().getName())) {
            resultBinder.rejectValue("complainant.name", "complainant.name.ismandatory");
        }
        if (complaint.getCrossHierarchyId() != null) {
            CrossHierarchy crosshierarchy = this.crossHierarchyService.findById(complaint.getCrossHierarchyId());
            complaint.setLocation(crosshierarchy.getParent());
            complaint.setChildLocation(crosshierarchy.getChild());
        }
        if (complaint.getLocation() == null && (complaint.getLat() == 0.0 || complaint.getLng() == 0.0)) {
            resultBinder.rejectValue(LOCATION, "location.required");
        }
        if (resultBinder.hasErrors()) {
            if (null != complaint.getCrossHierarchyId()) {
                model.addAttribute("crossHierarchyLocation", (Object)(complaint.getChildLocation().getName() + " - " + complaint.getLocation().getName()));
            }
            return ANONYMOUS_COMPLAINT_REGISTRATION_FORM;
        }
        try {
            complaint.setSupportDocs(this.fileStoreUtils.addToFileStore(files, "PGR", true));
            this.complaintService.createComplaint(complaint);
        }
        catch (ValidationException e) {
            resultBinder.rejectValue(LOCATION, e.getMessage());
            return ANONYMOUS_COMPLAINT_REGISTRATION_FORM;
        }
        redirectAttributes.addFlashAttribute("complaint", (Object)complaint);
        return "redirect:/complaint/reg-success/" + complaint.getCrn();
    }
}

