/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.complaint;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.admin.master.service.CrossHierarchyService;
import org.egov.infra.utils.FileStoreUtils;
import org.egov.pgr.entity.Complaint;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.entity.ComplaintTypeCategory;
import org.egov.pgr.service.ComplaintService;
import org.egov.pgr.service.ComplaintTypeCategoryService;
import org.egov.pgr.service.ComplaintTypeService;
import org.egov.pgr.service.ConfigurationService;
import org.egov.pgr.service.ReceivingCenterService;
import org.egov.pgr.service.ReceivingModeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class GenericComplaintController {
    @Autowired
    protected ComplaintTypeService complaintTypeService;
    @Autowired
    protected ComplaintService complaintService;
    @Autowired
    protected CrossHierarchyService crossHierarchyService;
    @Autowired
    protected ReceivingCenterService receivingCenterService;
    @Autowired
    protected ReceivingModeService receivingModeService;
    @Autowired
    protected ComplaintTypeCategoryService complaintTypeCategoryService;
    @Autowired
    protected FileStoreUtils fileStoreUtils;
    @Autowired
    protected ConfigurationService configurationService;

    @ModelAttribute(value="useAutoCompleteComplaintType")
    public boolean useAutoCompleteComplaintType() {
        return this.configurationService.useAutoCompleteForComplaintType();
    }

    @ModelAttribute(value="categories")
    public List<ComplaintTypeCategory> complaintTypeCategories() {
        return this.complaintTypeCategoryService.findAll();
    }

    @ModelAttribute(value="complaintTypes")
    public List<ComplaintType> frequentlyFiledComplaintTypes() {
        return this.complaintTypeService.getFrequentlyFiledComplaints();
    }

    @GetMapping(value={"/complaint/reg-success/{crn}"})
    public ModelAndView successView(@ModelAttribute Complaint complaint, @PathVariable String crn) {
        Complaint registeredComplaint = complaint;
        if (StringUtils.isNotBlank((CharSequence)crn) && complaint.isNew()) {
            registeredComplaint = this.complaintService.getComplaintByCRN(crn);
        }
        return new ModelAndView("complaint/reg-success", "complaint", (Object)registeredComplaint);
    }

    @GetMapping(value={"/complaint/downloadfile/{fileStoreId}"})
    public void download(@PathVariable String fileStoreId, HttpServletResponse response) {
        this.fileStoreUtils.writeToHttpResponseStream(fileStoreId, "PGR", response);
    }

    protected void setReceivingMode(Complaint complaint, String receivingModeCode) {
        complaint.setReceivingMode(this.receivingModeService.getReceivingModeByCode(receivingModeCode));
    }
}

