/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.complaint;

import java.util.Date;
import java.util.List;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.EmployeeViewService;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CrossHierarchyService;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.entity.ReceivingCenter;
import org.egov.pgr.service.ComplaintTypeService;
import org.egov.pgr.service.ReceivingCenterService;
import org.egov.pims.commons.Designation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class GenericComplaintAjaxController {
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private CrossHierarchyService crossHierarchyService;
    @Autowired
    private ReceivingCenterService receivingCenterService;
    @Autowired
    private ComplaintTypeService complaintTypeService;
    @Autowired
    private EmployeeViewService employeeViewService;

    @GetMapping(value={"/complaint/citizen/complaintTypes", "/complaint/citizen/anonymous/complaintTypes", "/complaint/officials/complaintTypes", "/complaint/router/complaintTypes", "/complaint/escalationTime/complaintTypes"}, produces={"application/json"})
    @ResponseBody
    public List<ComplaintType> getAllActiveComplaintTypesByNameLike(@RequestParam String complaintTypeName) {
        return this.complaintTypeService.findAllActiveByNameLike(complaintTypeName);
    }

    @GetMapping(value={"/complaint/citizen/complainttypes-by-category", "/complaint/citizen/anonymous/complainttypes-by-category", "/complaint/officials/complainttypes-by-category"}, produces={"application/json"})
    @ResponseBody
    public List<ComplaintType> complaintTypesByCategory(@RequestParam Long categoryId) {
        return this.complaintTypeService.findActiveComplaintTypesByCategory(categoryId);
    }

    @GetMapping(value={"/complaint/complaintTypes"}, produces={"application/json"})
    @ResponseBody
    public List<ComplaintType> getAllComplaintTypesByNameLike(@RequestParam String complaintTypeName) {
        return this.complaintTypeService.findAllActiveByNameLike(complaintTypeName);
    }

    @GetMapping(value={"/complaint/escalationTime/ajax-approvalDesignations"}, produces={"application/json"})
    @ResponseBody
    public List<Designation> getAllDesignationsByName(@RequestParam String designationName) {
        return this.designationService.getAllDesignationsByNameLike(designationName);
    }

    @GetMapping(value={"/complaint/officials/isCrnRequired"})
    @ResponseBody
    public boolean isCrnRequired(@RequestParam Long receivingCenterId) {
        ReceivingCenter receivingCenter = this.receivingCenterService.findByRCenterId(receivingCenterId);
        return receivingCenter == null || receivingCenter.isCrnRequired();
    }

    @GetMapping(value={"/complaint/citizen/locations", "/complaint/citizen/anonymous/locations", "/complaint/officials/locations"}, produces={"text/plain"})
    @ResponseBody
    public String getAllLocationJSON(@RequestParam String locationName) {
        StringBuilder locationJSONData = new StringBuilder();
        locationJSONData.append("[");
        this.crossHierarchyService.getChildBoundaryNameAndBndryTypeAndHierarchyType("Locality", "Location", "Administration", "%" + locationName + "%").stream().filter(ch -> ch.getParent().isActive() && ch.getChild().isActive()).forEach(location -> locationJSONData.append("{\"name\":\"").append(location.getChild().getName()).append(" - ").append(location.getParent().getName()).append("\",\"id\":").append(location.getId()).append("},"));
        if (locationJSONData.lastIndexOf(",") != -1) {
            locationJSONData.deleteCharAt(locationJSONData.lastIndexOf(","));
        }
        locationJSONData.append("]");
        return locationJSONData.toString();
    }

    @GetMapping(value={"/complaint/router/position", "/complaint/escalation/position"}, produces={"text/plain"})
    @ResponseBody
    public String getAllPositionByNameLike(@RequestParam String positionName) {
        StringBuilder positionUser = new StringBuilder();
        positionUser.append("[");
        String likePositionName = "%" + positionName.toUpperCase() + "%";
        this.employeeViewService.getEmployeeByNameOrCodeOrPositionLike(likePositionName, likePositionName, likePositionName, new Date()).stream().forEach(employee -> positionUser.append("{\"name\":\"").append(employee.getPosition().getName()).append('-').append(employee.getName()).append('-').append(employee.getCode()).append("\",\"id\":").append(employee.getPosition().getId()).append("},"));
        if (positionUser.lastIndexOf(",") != -1) {
            positionUser.deleteCharAt(positionUser.lastIndexOf(","));
        }
        positionUser.append("]");
        return positionUser.toString();
    }

    @GetMapping(value={"/complaint/router/boundaries-by-type", "/complaint/escalation/boundaries-by-type"}, produces={"application/json"})
    @ResponseBody
    public List<Boundary> getBoundariesByType(@RequestParam String boundaryName, @RequestParam Long boundaryTypeId) {
        return this.boundaryService.getBondariesByNameAndTypeOrderByBoundaryNumAsc("%" + boundaryName + "%", boundaryTypeId);
    }
}

