/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.complaint;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.egov.eis.entity.EmployeeView;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.CrossHierarchyService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.JsonUtils;
import org.egov.pgr.entity.contract.ProcessOwnerAdaptor;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.pims.service.EisUtilService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ComplaintProcessOwnerSelectionController {
    @Autowired
    private EisUtilService eisService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private CrossHierarchyService crossHierarchyService;
    @Autowired
    private SecurityUtils securityUtils;

    @GetMapping(value={"/ajax-getChildLocation"}, produces={"application/json"})
    @ResponseBody
    public List<Boundary> getChildBoundariesById(@RequestParam Long id) {
        return this.crossHierarchyService.getActiveChildBoundariesByParentId(id);
    }

    @GetMapping(value={"/ajax-approvalDesignations", "/ajax-designationsByDepartment"}, produces={"application/json"})
    @ResponseBody
    public List<Designation> getDesignations(@ModelAttribute(value="designations") @RequestParam Long approvalDepartment) {
        return this.designationService.getAllDesignationByDepartment(approvalDepartment);
    }

    @GetMapping(value={"/ajax-positionsByDepartmentAndDesignation"}, produces={"application/json"})
    @ResponseBody
    public List<Position> getPositionByDepartmentAndDesignation(@RequestParam Long approvalDepartment, @RequestParam Long approvalDesignation) {
        return this.positionMasterService.getPositionsByDepartmentAndDesignationId(approvalDepartment, approvalDesignation);
    }

    @GetMapping(value={"/ajax-approvalPositions"}, produces={"text/plain"})
    @ResponseBody
    public String getPositions(@RequestParam Integer approvalDepartment, @RequestParam Integer approvalDesignation) {
        if (approvalDepartment != null && approvalDepartment != 0 && approvalDesignation != null && approvalDesignation != 0) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("departmentId", String.valueOf(approvalDepartment));
            paramMap.put("designationId", String.valueOf(approvalDesignation));
            List employeeViewData = this.eisService.getEmployeeInfoList(paramMap);
            Set processOwners = employeeViewData.stream().filter(employeeView -> (employeeView.getEmployee().hasRole("Redressal Officer") || employeeView.getEmployee().hasRole("Grievance Officer") || employeeView.getEmployee().hasRole("Grievance Routing Officer")) && !this.securityUtils.getCurrentUser().getName().equals(employeeView.getName())).collect(Collectors.toSet());
            return JsonUtils.toJSON(processOwners, EmployeeView.class, ProcessOwnerAdaptor.class);
        }
        return "[]";
    }
}

