/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.reports;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.infra.utils.JsonUtils;
import org.egov.pgr.service.reports.FunctionaryWiseReportService;
import org.egov.pgr.web.controller.reports.DrillDownReportHelperAdaptor;
import org.egov.pgr.web.controller.reports.DrillDownReportResult;
import org.egov.pgr.web.controller.reports.DrillDownReportWithcompTypeAdaptor;
import org.egov.pgr.web.controller.reports.ReportHelper;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/functionaryWiseReport"})
public class FunctionaryWiseReportController {
    @Autowired
    private FunctionaryWiseReportService functionaryWiseReportService;

    @ModelAttribute
    public void getReportHelper(Model model) {
        model.addAttribute("reportHelper", (Object)new ReportHelper());
    }

    @GetMapping(value={"search"})
    public String searchAgeingReportByBoundaryForm() {
        return "functionaryWise-search";
    }

    @GetMapping(value={"result"})
    @ResponseBody
    public void result(@RequestParam String usrid, @RequestParam String status, @RequestParam String complaintDateType, @RequestParam DateTime fromDate, @RequestParam DateTime toDate, HttpServletResponse response) throws IOException {
        String result;
        if (usrid != null && status != null && !"".equals(usrid) && !"".equals(status)) {
            SQLQuery functionaryReportQuery = this.functionaryWiseReportService.getFunctionaryWiseReportQuery(fromDate, toDate, usrid, complaintDateType, status);
            functionaryReportQuery.setResultTransformer(Transformers.aliasToBean(DrillDownReportResult.class));
            List functionaryReportResult = functionaryReportQuery.list();
            result = "{ \"data\":" + JsonUtils.toJSON((Collection)functionaryReportResult, DrillDownReportResult.class, DrillDownReportWithcompTypeAdaptor.class) + "}";
        } else {
            SQLQuery functionaryReportQuery = this.functionaryWiseReportService.getFunctionaryWiseReportQuery(fromDate, toDate, usrid, complaintDateType);
            functionaryReportQuery.setResultTransformer(Transformers.aliasToBean(DrillDownReportResult.class));
            List functionaryReportResult = functionaryReportQuery.list();
            result = "{ \"data\":" + JsonUtils.toJSON((Collection)functionaryReportResult, DrillDownReportResult.class, DrillDownReportHelperAdaptor.class) + "}";
        }
        response.setContentType("application/json");
        IOUtils.write((String)result, (Writer)response.getWriter());
    }
}

