/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.masters;

import java.util.List;
import javax.validation.Valid;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.entity.ComplaintTypeCategory;
import org.egov.pgr.service.ComplaintTypeCategoryService;
import org.egov.pgr.service.ComplaintTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/complainttype/update/{code}"})
public class UpdateComplaintTypeController {
    private static final String COMPLAINTTYPE_UPDATE_SUCCESS = "/complaintType-success";
    private final DepartmentService departmentService;
    private final ComplaintTypeService complaintTypeService;
    @Autowired
    private ComplaintTypeCategoryService complaintTypeCategoryService;

    @Autowired
    public UpdateComplaintTypeController(DepartmentService departmentService, ComplaintTypeService complaintTypeService) {
        this.departmentService = departmentService;
        this.complaintTypeService = complaintTypeService;
    }

    @ModelAttribute(value="categories")
    public List<ComplaintTypeCategory> categories() {
        return this.complaintTypeCategoryService.findAll();
    }

    @ModelAttribute(value="departments")
    public List<Department> departments() {
        return this.departmentService.getAllDepartments();
    }

    @ModelAttribute
    public ComplaintType complaintTypeModel(@PathVariable String code, Model model) {
        model.addAttribute("mode", (Object)"update");
        return this.complaintTypeService.findByCode(code);
    }

    @RequestMapping(method={RequestMethod.GET})
    public String complaintTypeFormForUpdate() {
        return "complaint-type";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String updateComplaintType(@Valid @ModelAttribute ComplaintType complaintType, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (errors.hasErrors()) {
            return "complaint-type";
        }
        complaintType = this.complaintTypeService.updateComplaintType(complaintType);
        redirectAttrs.addFlashAttribute("complaintType", (Object)complaintType);
        redirectAttrs.addFlashAttribute("message", (Object)"msg.comp.type.update.success");
        return "redirect:" + complaintType.getCode() + COMPLAINTTYPE_UPDATE_SUCCESS;
    }

    @RequestMapping(value={"/complaintType-success"})
    public ModelAndView successView(@PathVariable String code, @ModelAttribute ComplaintType complaintType) {
        return new ModelAndView("complaintType/complaintType-success", "complaintType", (Object)this.complaintTypeService.findByCode(code));
    }
}

