/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.masters;

import java.util.List;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.infra.web.support.ui.DataTable;
import org.egov.pgr.entity.ComplaintRouter;
import org.egov.pgr.entity.ComplaintRouterResponseAdaptor;
import org.egov.pgr.entity.dto.ComplaintRouterSearchRequest;
import org.egov.pgr.service.ComplaintRouterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/router"})
public class SearchRoutingController {
    public static final String CONTENTTYPE_JSON = "application/json";
    protected BoundaryTypeService boundaryTypeService;
    protected ComplaintRouterService complaintRouterService;

    @Autowired
    public SearchRoutingController(BoundaryTypeService boundaryTypeService, ComplaintRouterService complaintRouterService) {
        this.boundaryTypeService = boundaryTypeService;
        this.complaintRouterService = complaintRouterService;
    }

    @ModelAttribute
    public ComplaintRouter complaintRouter() {
        return new ComplaintRouter();
    }

    @ModelAttribute(value="boundaryTypes")
    public List<BoundaryType> boundaryTypes() {
        return this.boundaryTypeService.getBoundaryTypeByHierarchyTypeName("ADMINISTRATION");
    }

    @GetMapping(value={"/search-update"})
    public String searchRouterUpdateForm(Model model) {
        model.addAttribute("boundaryTypes", (Object)this.boundaryTypeService.getBoundaryTypeByHierarchyTypeName("ADMINISTRATION"));
        return "router-searchUpdate";
    }

    @GetMapping(value={"/search-view"})
    public String searchRouterViewForm(Model model) {
        model.addAttribute("boundaryTypes", (Object)this.boundaryTypeService.getBoundaryTypeByHierarchyTypeName("ADMINISTRATION"));
        return "router-searchView";
    }

    @GetMapping(value={"/resultList-view"}, produces={"text/plain"})
    @ResponseBody
    public String search(ComplaintRouterSearchRequest routerSearchRequest) {
        return new DataTable(this.complaintRouterService.getComplaintRouter(routerSearchRequest), (long)routerSearchRequest.draw()).toJson(ComplaintRouterResponseAdaptor.class);
    }
}

