/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.dashboard.es;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.entity.ComplaintTypeCategory;
import org.egov.pgr.entity.es.ComplaintDashBoardRequest;
import org.egov.pgr.entity.es.ComplaintIndex;
import org.egov.pgr.service.ComplaintTypeCategoryService;
import org.egov.pgr.service.ComplaintTypeService;
import org.egov.pgr.service.es.ComplaintIndexService;
import org.json.simple.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/complaint/aggregate"})
public class ComplaintIndexController {
    @Autowired
    private ComplaintIndexService complaintIndexService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private ComplaintTypeService complaintTypeService;
    @Autowired
    private ComplaintTypeCategoryService complaintTypeCategoryService;
    @Autowired
    private BoundaryService boundaryService;

    @RequestMapping(value={"/grievance"}, method={RequestMethod.POST}, produces={"application/json"})
    public Map<String, Object> getDashBoardResponse(@RequestBody ComplaintDashBoardRequest complaintRequest) {
        return this.complaintIndexService.getGrievanceReport(complaintRequest);
    }

    @RequestMapping(value={"/grievance/complainttype"}, method={RequestMethod.POST}, produces={"application/json"})
    public Map<String, Object> getGrievanceComplaintTypeResponse(@RequestBody ComplaintDashBoardRequest complaintRequest) {
        return this.complaintIndexService.getComplaintTypeReport(complaintRequest);
    }

    @RequestMapping(value={"/sourcewisegrievance"}, method={RequestMethod.POST}, produces={"application/json"})
    public Map<String, Object> getSourceWiseGrievanceResponse(@RequestBody ComplaintDashBoardRequest complaintRequest) {
        return this.complaintIndexService.getSourceWiseResponse(complaintRequest);
    }

    @RequestMapping(value={"/departments"}, method={RequestMethod.POST}, produces={"application/json"})
    public List<JSONObject> getDepartments() {
        List departments = this.departmentService.getAllDepartments();
        ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>();
        for (Department department : departments) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"name", (Object)department.getName());
            jsonObject.put((Object)"code", (Object)department.getCode());
            jsonList.add(jsonObject);
        }
        return jsonList;
    }

    @RequestMapping(value={"/complainttypes"}, method={RequestMethod.POST}, produces={"application/json"})
    public List<JSONObject> getComplaintTypes(@RequestBody ComplaintDashBoardRequest complaintRequest) {
        List complaintTypeList = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)complaintRequest.getCategoryId()) ? this.complaintTypeService.findActiveComplaintTypesByCategory(Long.valueOf(complaintRequest.getCategoryId())) : this.complaintTypeService.findAll();
        ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>();
        for (ComplaintType complaintType : complaintTypeList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"name", (Object)complaintType.getName());
            jsonObject.put((Object)"code", (Object)complaintType.getCode());
            jsonList.add(jsonObject);
        }
        return jsonList;
    }

    @RequestMapping(value={"/complainttypecategories"}, method={RequestMethod.POST}, produces={"application/json"})
    public List<JSONObject> getComplaintTypeCategories() {
        List complaintTypeCategoryList = this.complaintTypeCategoryService.findAll();
        ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>();
        for (ComplaintTypeCategory complaintTypeCategory : complaintTypeCategoryList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"id", (Object)complaintTypeCategory.getId());
            jsonObject.put((Object)"name", (Object)complaintTypeCategory.getName());
            jsonList.add(jsonObject);
        }
        return jsonList;
    }

    @RequestMapping(value={"/wards"}, method={RequestMethod.POST}, produces={"application/json"})
    public List<JSONObject> getWards() {
        List boundaryList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "ADMINISTRATION");
        ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>();
        for (Boundary boundary : boundaryList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"name", (Object)boundary.getName());
            jsonObject.put((Object)"boundaryNumber", (Object)boundary.getBoundaryNum());
            jsonObject.put((Object)"lat", (Object)boundary.getLatitude());
            jsonObject.put((Object)"lon", (Object)boundary.getLongitude());
            jsonList.add(jsonObject);
        }
        return jsonList;
    }

    @RequestMapping(value={"/sourcenames"}, method={RequestMethod.POST}, produces={"application/json"})
    public List<String> getSourceNameList() throws JsonProcessingException {
        return this.complaintIndexService.getSourceNameList();
    }

    @RequestMapping(value={"/grievance/allfunctionaries"}, method={RequestMethod.POST}, produces={"application/json"})
    public Map<String, Object> getAllFunctionaryResponse(@RequestBody ComplaintDashBoardRequest complaintRequest) {
        return this.complaintIndexService.getAllFunctionaryResponse(complaintRequest);
    }

    @RequestMapping(value={"/grievance/allulb"}, method={RequestMethod.POST}, produces={"application/json"})
    public Map<String, Object> getAllUlbResponse(@RequestBody ComplaintDashBoardRequest complaintRequest) {
        return this.complaintIndexService.getAllUlbResponse(complaintRequest);
    }

    @RequestMapping(value={"/grievance/allwards"}, method={RequestMethod.POST}, produces={"application/json"})
    public Map<String, Object> getAllWardsResponse(@RequestBody ComplaintDashBoardRequest complaintRequest) {
        return this.complaintIndexService.getAllWardResponse(complaintRequest);
    }

    @RequestMapping(value={"/grievance/alllocalities"}, method={RequestMethod.POST}, produces={"application/json"})
    public Map<String, Object> getAllLocalitiesResponse(@RequestBody ComplaintDashBoardRequest complaintRequest) {
        return this.complaintIndexService.getAllLocalityResponse(complaintRequest);
    }

    @RequestMapping(value={"/functionaryWiseComplaints"}, method={RequestMethod.POST}, produces={"application/json"})
    public List<ComplaintIndex> getFunctionaryWiseComplaints(@RequestParam String functionaryName) {
        return this.complaintIndexService.getFunctionaryWiseComplaints(functionaryName);
    }

    @RequestMapping(value={"/localityWiseComplaints"}, method={RequestMethod.POST}, produces={"application/json"})
    public List<ComplaintIndex> getLocalityWiseComplaints(@RequestParam String localityName) {
        return this.complaintIndexService.getLocalityWiseComplaints(localityName);
    }

    @RequestMapping(value={"/complaints"}, method={RequestMethod.POST}, produces={"application/json"})
    public List<ComplaintIndex> getFilteredComplaints(@RequestBody ComplaintDashBoardRequest complaintRequest, @RequestParam String fieldName, @RequestParam String fieldValue) {
        if (StringUtils.isEmpty((String)complaintRequest.getSortField())) {
            complaintRequest.setSortField("createdDate");
        }
        if (StringUtils.isEmpty((String)complaintRequest.getSortDirection())) {
            complaintRequest.setSortDirection("DESC");
        }
        if (complaintRequest.getSize() == 0) {
            complaintRequest.setSize(10000);
        }
        return this.complaintIndexService.getFilteredComplaints(complaintRequest, fieldName, fieldValue);
    }
}

