/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.contract;

import org.apache.commons.lang3.StringUtils;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.utils.DateUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.joda.time.DateTime;

public class ComplaintSearchRequest {
    private String fromDate;
    private String toDate;
    private BoolQueryBuilder searchQueryBuilder = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchAllQuery());

    public void setComplaintNumber(String complaintNumber) {
        if (StringUtils.isNotBlank((CharSequence)complaintNumber)) {
            this.searchQueryBuilder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"crn", (Object)complaintNumber));
        }
    }

    public void setComplaintStatus(String complaintStatus) {
        if (StringUtils.isNotBlank((CharSequence)complaintStatus)) {
            this.searchQueryBuilder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"complaintStatusName", (Object)complaintStatus));
        }
    }

    public void setComplainantName(String complainantName) {
        if (StringUtils.isNotBlank((CharSequence)complainantName)) {
            this.searchQueryBuilder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"complainantName", (Object)complainantName));
        }
    }

    public void setLocation(String location) {
        if (StringUtils.isNotBlank((CharSequence)location)) {
            this.searchQueryBuilder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"wardName", (Object)location));
        }
    }

    public void setComplainantPhoneNumber(String phoneNumber) {
        if (StringUtils.isNotBlank((CharSequence)phoneNumber)) {
            this.searchQueryBuilder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"complainantMobile", (Object)phoneNumber));
        }
    }

    public void setComplainantEmail(String email) {
        if (StringUtils.isNotBlank((CharSequence)email)) {
            this.searchQueryBuilder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"complainantEmail", (Object)email));
        }
    }

    public void setReceivingCenter(String receivingCenter) {
        if (StringUtils.isNotBlank((CharSequence)receivingCenter)) {
            this.searchQueryBuilder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"receivingMode", (Object)receivingCenter));
        }
    }

    public void setComplaintType(String complaintType) {
        if (StringUtils.isNotBlank((CharSequence)complaintType)) {
            this.searchQueryBuilder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"complaintTypeName", (Object)complaintType));
        }
    }

    public void setFromDate(String fromDate) {
        if (fromDate != null) {
            this.fromDate = DateUtils.startOfGivenDate((DateTime)DateUtils.TO_DEFAULT_DATE_FORMAT.parseDateTime(fromDate)).toString("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        }
    }

    public void setToDate(String toDate) {
        if (toDate != null) {
            this.toDate = DateUtils.endOfGivenDate((DateTime)DateUtils.TO_DEFAULT_DATE_FORMAT.parseDateTime(toDate)).toString("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        }
    }

    public void setComplaintDepartment(String complaintDepartment) {
        if (StringUtils.isNotBlank((CharSequence)complaintDepartment)) {
            this.searchQueryBuilder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"departmentName", (Object)complaintDepartment));
        }
    }

    public void setComplaintDate(String complaintDate) {
        if (null != complaintDate) {
            DateTime currentDate = new DateTime();
            this.toDate = DateUtils.endOfGivenDate((DateTime)currentDate).toString("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            if ("today".equalsIgnoreCase(complaintDate)) {
                this.fromDate = currentDate.withTimeAtStartOfDay().toString("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            } else if ("lastsevendays".equalsIgnoreCase(complaintDate)) {
                this.fromDate = currentDate.minusDays(7).toString("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            } else if ("lastthirtydays".equalsIgnoreCase(complaintDate)) {
                this.fromDate = currentDate.minusDays(30).toString("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            } else if ("lastninetydays".equalsIgnoreCase(complaintDate)) {
                this.fromDate = currentDate.minusDays(90).toString("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            } else {
                this.fromDate = null;
                this.toDate = null;
            }
        }
    }

    public BoolQueryBuilder query() {
        this.searchQueryBuilder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"cityCode", (Object)ApplicationThreadLocals.getCityCode()));
        if (StringUtils.isNotBlank((CharSequence)this.fromDate) || StringUtils.isNotBlank((CharSequence)this.toDate)) {
            this.searchQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"createdDate").from(this.fromDate).to(this.toDate));
        }
        return this.searchQueryBuilder;
    }
}

