/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.egov.eis.entity.EmployeeView;
import org.egov.eis.entity.EmployeeViewAdaptor;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.CrossHierarchyService;
import org.egov.infstr.services.EISServeable;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AjaxController {
    @Autowired
    private EISServeable eisService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private CrossHierarchyService crossHierarchyService;

    @RequestMapping(value={"/ajax-getChildLocation"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Boundary> getChildBoundariesById(@RequestParam Long id) {
        return this.crossHierarchyService.getActiveChildBoundariesByBoundaryId(id);
    }

    @RequestMapping(value={"/ajax-approvalDesignations"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Designation> getDesignations(@ModelAttribute(value="designations") @RequestParam Integer approvalDepartment) {
        List designations = this.eisService.getAllDesignationByDept(approvalDepartment, new Date());
        designations.forEach(designation -> designation.toString());
        return designations;
    }

    @RequestMapping(value={"/ajax-designationsByDepartment"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Designation> getDesignationsByDepartmentId(@ModelAttribute(value="designations") @RequestParam Long approvalDepartment) {
        List designations = this.designationService.getAllDesignationByDepartment(approvalDepartment, new Date());
        designations.forEach(designation -> designation.toString());
        return designations;
    }

    @RequestMapping(value={"/ajax-positionsByDepartmentAndDesignation"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Position> getPositionByDepartmentAndDesignation(@RequestParam Long approvalDepartment, @RequestParam Long approvalDesignation, HttpServletResponse response) {
        List<Position> positions = new ArrayList();
        positions = this.positionMasterService.getPositionsByDepartmentAndDesignationForGivenRange(approvalDepartment, approvalDesignation, new Date());
        positions.forEach(position -> position.toString());
        return positions;
    }

    @RequestMapping(value={"/ajax-approvalPositions"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String getPositions(@RequestParam Integer approvalDepartment, @RequestParam Integer approvalDesignation, HttpServletResponse response) throws IOException {
        if (approvalDepartment != null && approvalDepartment != 0 && approvalDesignation != null && approvalDesignation != 0) {
            HashSet users = new HashSet();
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("departmentId", String.valueOf(approvalDepartment));
            paramMap.put("designationId", String.valueOf(approvalDesignation));
            List empViewList = this.eisService.getEmployeeInfoList(paramMap);
            empViewList.stream().forEach(user -> user.getEmployee().getRoles().stream().forEach(role -> {
                if (role.getName().matches("Redressal Officer|Grievance Officer|Grievance Routing Officer")) {
                    users.add(user);
                }
            }));
            Gson jsonCreator = new GsonBuilder().registerTypeAdapter(EmployeeView.class, (Object)new EmployeeViewAdaptor()).create();
            return jsonCreator.toJson(users, new /* Unavailable Anonymous Inner Class!! */.getType());
        }
        return "[]";
    }
}

