/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.reports;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.utils.JsonUtils;
import org.egov.pgr.entity.dto.RouterEscalationForm;
import org.egov.pgr.service.ComplaintTypeCategoryService;
import org.egov.pgr.service.reports.RouterEscalationService;
import org.egov.pgr.web.controller.response.adaptor.RouterEscalationAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"routerescalation"})
public class RouterEscalationReportController {
    private ComplaintTypeCategoryService complaintTypeCategoryService;
    private BoundaryService boundaryService;
    private RouterEscalationService routerEscalationService;

    @Autowired
    public RouterEscalationReportController(ComplaintTypeCategoryService complaintTypeCategoryService, BoundaryService boundaryService, RouterEscalationService routerEscalationService) {
        this.complaintTypeCategoryService = complaintTypeCategoryService;
        this.boundaryService = boundaryService;
        this.routerEscalationService = routerEscalationService;
    }

    @ModelAttribute
    public RouterEscalationForm routerEscalationForm() {
        return new RouterEscalationForm();
    }

    @RequestMapping(value={"/search-form"}, method={RequestMethod.GET})
    public String searchBaseRegister(Model model) {
        model.addAttribute("categories", (Object)this.complaintTypeCategoryService.findAll());
        model.addAttribute("complaintTypes", Collections.emptyList());
        model.addAttribute("wardList", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "ADMINISTRATION"));
        return "routerescalation-report";
    }

    @RequestMapping(value={"/search-resultList"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String search(@ModelAttribute RouterEscalationForm routerEscalationForm) throws IOException {
        return "{ \"data\":" + JsonUtils.toJSON((Collection)this.routerEscalationService.search(routerEscalationForm), RouterEscalationForm.class, RouterEscalationAdaptor.class) + "}";
    }
}

