/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.masters.escalationTime;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.eis.service.DesignationService;
import org.egov.infra.utils.JsonUtils;
import org.egov.pgr.entity.Escalation;
import org.egov.pgr.service.ComplaintTypeService;
import org.egov.pgr.service.EscalationService;
import org.egov.pgr.web.controller.masters.escalationTime.EscalationTimeAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/escalationTime"})
public class ViewEscalationTimeController {
    public static final String CONTENTTYPE_JSON = "application/json";
    protected ComplaintTypeService complaintTypeService;
    protected EscalationService escalationService;
    protected DesignationService designationService;

    @Autowired
    public ViewEscalationTimeController(ComplaintTypeService complaintTypeService, EscalationService escalationService, DesignationService designationService) {
        this.complaintTypeService = complaintTypeService;
        this.escalationService = escalationService;
        this.designationService = designationService;
    }

    @ModelAttribute
    public Escalation escalation() {
        return new Escalation();
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String searchForm(@ModelAttribute Escalation escalation, Model model) {
        model.addAttribute("mode", (Object)"new");
        return "escalationTime-search";
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.POST})
    public String searchEscalationTimeForm(@ModelAttribute Escalation escalation, Model model) {
        model.addAttribute("mode", (Object)"new");
        return "escalationTime-search";
    }

    @RequestMapping(value={"resultList-update"}, method={RequestMethod.GET})
    @ResponseBody
    public void springPaginationDataTablesUpdate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Long complaintTypeId = 0L;
        Long designationId = 0L;
        int pageStart = Integer.valueOf(request.getParameter("start"));
        int pageSize = Integer.valueOf(request.getParameter("length"));
        if (request.getParameter("complaintTypeId") != null && !"".equals(request.getParameter("complaintTypeId"))) {
            complaintTypeId = Long.valueOf(request.getParameter("complaintTypeId"));
        }
        if (request.getParameter("designationId") != null && !"".equals(request.getParameter("designationId"))) {
            designationId = Long.valueOf(request.getParameter("designationId"));
        }
        int pageNumber = pageStart / pageSize + 1;
        String escalationTimeRouterJSONData = this.commonSearchResult(Integer.valueOf(pageNumber), Integer.valueOf(pageSize), complaintTypeId, designationId);
        response.setContentType(CONTENTTYPE_JSON);
        IOUtils.write((String)escalationTimeRouterJSONData, (Writer)response.getWriter());
    }

    public String commonSearchResult(Integer pageNumber, Integer pageSize, Long complaintTypeId, Long designationId) {
        Page pageOfEscalation = this.escalationService.getPageOfEscalations(pageNumber, pageSize, complaintTypeId, designationId);
        List positionList = pageOfEscalation.getContent();
        StringBuilder complaintRouterJSONData = new StringBuilder();
        complaintRouterJSONData.append("{\"draw\": ").append("0");
        complaintRouterJSONData.append(",\"recordsTotal\":").append(pageOfEscalation.getTotalElements());
        complaintRouterJSONData.append(",\"totalDisplayRecords\":").append(pageSize);
        complaintRouterJSONData.append(",\"recordsFiltered\":").append(pageOfEscalation.getTotalElements());
        complaintRouterJSONData.append(",\"data\":").append(JsonUtils.toJSON((Collection)positionList, Escalation.class, EscalationTimeAdaptor.class)).append("}");
        return complaintRouterJSONData.toString();
    }
}

