/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.complaint;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.admin.master.service.CrossHierarchyService;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.utils.FileStoreUtils;
import org.egov.pgr.entity.Complaint;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.entity.ComplaintTypeCategory;
import org.egov.pgr.service.ComplaintService;
import org.egov.pgr.service.ComplaintTypeCategoryService;
import org.egov.pgr.service.ComplaintTypeService;
import org.egov.pgr.service.ReceivingCenterService;
import org.egov.pgr.service.ReceivingModeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class GenericComplaintController {
    @Autowired
    protected ComplaintTypeService complaintTypeService;
    @Autowired
    protected ComplaintService complaintService;
    @Autowired
    protected CrossHierarchyService crossHierarchyService;
    @Autowired
    protected ReceivingCenterService receivingCenterService;
    @Autowired
    protected ReceivingModeService receivingModeService;
    @Autowired
    protected ComplaintTypeCategoryService complaintTypeCategoryService;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    protected FileStoreUtils fileStoreUtils;

    @ModelAttribute(value="categories")
    public List<ComplaintTypeCategory> complaintTypeCategories() {
        return this.complaintTypeCategoryService.findAll();
    }

    @ModelAttribute(value="complaintTypes")
    public List<ComplaintType> frequentlyFiledComplaintTypes() {
        return this.complaintTypeService.getFrequentlyFiledComplaints();
    }

    @RequestMapping(value={"/complaint/reg-success/{crn}"}, method={RequestMethod.GET})
    public ModelAndView successView(@ModelAttribute Complaint complaint, @PathVariable String crn) {
        if (StringUtils.isNotBlank((CharSequence)crn) && complaint.isNew()) {
            complaint = this.complaintService.getComplaintByCRN(crn);
        }
        return new ModelAndView("complaint/reg-success", "complaint", (Object)complaint);
    }

    @RequestMapping(value={"/complaint/downloadfile/{fileStoreId}"})
    public void download(@PathVariable String fileStoreId, HttpServletResponse response) throws IOException {
        this.fileStoreUtils.fetchFileAndWriteToStream(fileStoreId, "PGR", false, response);
    }

    protected void setReceivingMode(Complaint complaint, String receivingModeCode) {
        complaint.setReceivingMode(this.receivingModeService.getReceivingModeByCode(receivingModeCode));
    }
}

