/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.reports;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.utils.JsonUtils;
import org.egov.pgr.service.reports.DrillDownReportService;
import org.egov.pgr.web.controller.reports.DrillDownReportHelperAdaptor;
import org.egov.pgr.web.controller.reports.DrillDownReportResult;
import org.egov.pgr.web.controller.reports.DrillDownReportWithcompTypeAdaptor;
import org.egov.pgr.web.controller.reports.ReportHelper;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report"})
public class DrillDownReportController {
    @Autowired
    private DrillDownReportService drillDownReportService;

    @ModelAttribute
    public void getReportHelper(Model model) {
        ReportHelper reportHealperObj = new ReportHelper();
        model.addAttribute("reportHelper", (Object)reportHealperObj);
    }

    @GetMapping(value={"drillDownReportByBoundary"})
    public String searchAgeingReportByBoundaryForm(Model model) {
        model.addAttribute("mode", (Object)"ByBoundary");
        return "drillDown-search";
    }

    @GetMapping(value={"drillDownReportByDept"})
    public String searchAgeingReportByDepartmentForm(Model model) {
        model.addAttribute("mode", (Object)"ByDepartment");
        return "drillDown-search";
    }

    @GetMapping(value={"drillDown/resultList-update"})
    @ResponseBody
    public void springPaginationDataTablesUpdate(@RequestParam String groupBy, @RequestParam String deptid, @RequestParam String complainttypeid, @RequestParam String selecteduserid, @RequestParam String boundary, @RequestParam String complaintDateType, @RequestParam DateTime fromDate, @RequestParam DateTime toDate, @RequestParam String locality, HttpServletResponse response) throws IOException {
        String result;
        if (StringUtils.isNotBlank((String)deptid) && StringUtils.isNotBlank((String)complainttypeid) && StringUtils.isNotBlank((String)selecteduserid)) {
            String userName = selecteduserid.split("~")[0];
            if ("".equals(userName)) {
                userName = null;
            }
            SQLQuery drillDownreportQuery = this.drillDownReportService.getDrillDownReportQuery(fromDate, toDate, complaintDateType, deptid, boundary, complainttypeid, userName, locality);
            drillDownreportQuery.setResultTransformer(Transformers.aliasToBean(DrillDownReportResult.class));
            List drillDownresult = drillDownreportQuery.list();
            result = "{ \"data\":" + JsonUtils.toJSON((Collection)drillDownresult, DrillDownReportResult.class, DrillDownReportWithcompTypeAdaptor.class) + "}";
        } else {
            SQLQuery drillDownreportQuery = this.drillDownReportService.getDrillDownReportQuery(fromDate, toDate, complaintDateType, groupBy, deptid, boundary, complainttypeid, selecteduserid, locality);
            drillDownreportQuery.setResultTransformer(Transformers.aliasToBean(DrillDownReportResult.class));
            List drillDownresult = drillDownreportQuery.list();
            result = "{ \"data\":" + JsonUtils.toJSON((Collection)drillDownresult, DrillDownReportResult.class, DrillDownReportHelperAdaptor.class) + "}";
        }
        response.setContentType("application/json");
        IOUtils.write((String)result, (Writer)response.getWriter());
    }
}

