/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.reports;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.infra.utils.JsonUtils;
import org.egov.pgr.service.reports.AgeingReportService;
import org.egov.pgr.web.controller.reports.AgeingReportHelperAdaptor;
import org.egov.pgr.web.controller.reports.AgeingReportResult;
import org.egov.pgr.web.controller.reports.ReportHelper;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report"})
public class AgeingReportController {
    @Autowired
    private AgeingReportService ageingReportService;

    @ModelAttribute
    public void getReportHelper(Model model) {
        ReportHelper reportHealperObj = new ReportHelper();
        LinkedHashMap<String, String> status = new LinkedHashMap<String, String>();
        status.put("Completed", "Completed");
        status.put("Pending", "Pending");
        status.put("Rejected", "Rejected");
        model.addAttribute("status", status);
        model.addAttribute("reportHelper", (Object)reportHealperObj);
    }

    @GetMapping(value={"ageingReportByBoundary"})
    public String searchAgeingReportByBoundaryForm(Model model) {
        model.addAttribute("mode", (Object)"ByBoundary");
        return "ageing-search";
    }

    @GetMapping(value={"ageingReportByDept"})
    public String searchAgeingReportByDepartmentForm(Model model) {
        model.addAttribute("mode", (Object)"ByDepartment");
        return "ageing-search";
    }

    @GetMapping(value={"/ageing/resultList-update"})
    @ResponseBody
    public void springPaginationDataTablesUpdate(@RequestParam String mode, @RequestParam String complaintDateType, @RequestParam DateTime fromDate, @RequestParam String status, @RequestParam DateTime toDate, HttpServletResponse response) throws IOException {
        SQLQuery ageingreportQuery = this.ageingReportService.getageingReportQuery(fromDate, toDate, status, complaintDateType, mode);
        ageingreportQuery.setResultTransformer(Transformers.aliasToBean(AgeingReportResult.class));
        List ageingresult = ageingreportQuery.list();
        String result = "{ \"data\":" + JsonUtils.toJSON((Collection)ageingresult, AgeingReportResult.class, AgeingReportHelperAdaptor.class) + "}";
        response.setContentType("application/json");
        IOUtils.write((String)result, (Writer)response.getWriter());
    }
}

