/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.masters.escalationTime;

import org.egov.eis.service.DesignationService;
import org.egov.infra.web.support.ui.DataTable;
import org.egov.pgr.entity.Escalation;
import org.egov.pgr.entity.dto.EscalationTimeSearchRequest;
import org.egov.pgr.service.ComplaintTypeService;
import org.egov.pgr.service.EscalationService;
import org.egov.pgr.web.controller.masters.escalationTime.EscalationTimeAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/escalationTime"})
public class ViewEscalationTimeController {
    public static final String CONTENTTYPE_JSON = "application/json";
    protected ComplaintTypeService complaintTypeService;
    protected EscalationService escalationService;
    protected DesignationService designationService;

    @Autowired
    public ViewEscalationTimeController(ComplaintTypeService complaintTypeService, EscalationService escalationService, DesignationService designationService) {
        this.complaintTypeService = complaintTypeService;
        this.escalationService = escalationService;
        this.designationService = designationService;
    }

    @ModelAttribute
    public Escalation escalation() {
        return new Escalation();
    }

    @GetMapping(value={"/search"})
    public String searchForm(@ModelAttribute Escalation escalation, Model model) {
        model.addAttribute("mode", (Object)"new");
        return "escalationTime-search";
    }

    @PostMapping(value={"/search"})
    public String searchEscalationTimeForm(@ModelAttribute Escalation escalation, Model model) {
        model.addAttribute("mode", (Object)"new");
        return "escalationTime-search";
    }

    @GetMapping(value={"resultList-update"}, produces={"text/plain"})
    @ResponseBody
    public String search(EscalationTimeSearchRequest escalationTimeSearchRequest) {
        return new DataTable(this.escalationService.getEscalationsTime(escalationTimeSearchRequest), (long)escalationTimeSearchRequest.draw()).toJson(EscalationTimeAdaptor.class);
    }
}

