/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.complaint.officials;

import java.util.List;
import javax.validation.Valid;
import javax.validation.ValidationException;
import org.egov.infra.admin.master.entity.CrossHierarchy;
import org.egov.pgr.entity.Complaint;
import org.egov.pgr.entity.ReceivingCenter;
import org.egov.pgr.entity.ReceivingMode;
import org.egov.pgr.web.controller.complaint.GenericComplaintController;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/complaint/officials/"})
public class OfficialsComplaintRegistrationController
extends GenericComplaintController {
    @ModelAttribute(value="receivingCenters")
    public List<ReceivingCenter> receivingCenters() {
        return this.receivingCenterService.findAll();
    }

    @ModelAttribute(value="receivingModes")
    public List<ReceivingMode> receivingModes() {
        return this.receivingModeService.getVisibleReceivingModes();
    }

    @RequestMapping(value={"show-reg-form"}, method={RequestMethod.GET})
    public String showComplaintRegistrationForm(@ModelAttribute Complaint complaint) {
        return "complaint/officials/registration-form";
    }

    @RequestMapping(value={"register"}, method={RequestMethod.POST})
    public String registerComplaint(@Valid @ModelAttribute Complaint complaint, BindingResult resultBinder, RedirectAttributes redirectAttributes, @RequestParam(value="files") MultipartFile[] files, Model model) {
        if (null != complaint.getCrossHierarchyId()) {
            CrossHierarchy crosshierarchy = this.crossHierarchyService.findById(complaint.getCrossHierarchyId());
            complaint.setLocation(crosshierarchy.getParent());
            complaint.setChildLocation(crosshierarchy.getChild());
        }
        if (complaint.getLocation() == null && (complaint.getLat() == 0.0 || complaint.getLng() == 0.0)) {
            resultBinder.rejectValue("location", "location.required");
        }
        if (resultBinder.hasErrors()) {
            if (null != complaint.getCrossHierarchyId()) {
                model.addAttribute("crossHierarchyLocation", (Object)(complaint.getChildLocation().getName() + " - " + complaint.getLocation().getName()));
            }
            return "complaint/officials/registration-form";
        }
        try {
            complaint.setSupportDocs(this.fileStoreUtils.addToFileStore(files, "PGR", true));
            this.complaintService.createComplaint(complaint);
        }
        catch (ValidationException e) {
            resultBinder.rejectValue("location", e.getMessage());
            return "complaint/officials/registration-form";
        }
        redirectAttributes.addFlashAttribute("complaint", (Object)complaint);
        return "redirect:/complaint/reg-success/" + complaint.getCrn();
    }
}

