/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.masters.escalation;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.commons.ObjectType;
import org.egov.commons.service.ObjectTypeService;
import org.egov.eis.entity.PositionHierarchy;
import org.egov.eis.service.PositionHierarchyService;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.service.ComplaintTypeService;
import org.egov.pgr.web.controller.masters.escalation.EscalationHelper;
import org.egov.pgr.web.controller.masters.escalation.EscalationHelperAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/escalation"})
public class SearchEscalationController {
    public static final String CONTENTTYPE_JSON = "application/json";
    protected final ComplaintTypeService complaintTypeService;
    private final ObjectTypeService objectTypeService;
    @Autowired
    private PositionHierarchyService positionHierarchyService;

    @ModelAttribute
    public PositionHierarchy positionHierarchy() {
        return new PositionHierarchy();
    }

    @Autowired
    public SearchEscalationController(ComplaintTypeService complaintTypeService, ObjectTypeService objectTypeService) {
        this.complaintTypeService = complaintTypeService;
        this.objectTypeService = objectTypeService;
    }

    @RequestMapping(value={"/view"}, method={RequestMethod.POST})
    public String searchEscalationTimeForm(@ModelAttribute PositionHierarchy positionHierarchy, Model model) {
        return "escalation-view";
    }

    @RequestMapping(value={"/view"}, method={RequestMethod.GET})
    public String searchForm(@ModelAttribute PositionHierarchy positionHierarchy, Model model) {
        return "escalation-view";
    }

    @ExceptionHandler(value={Exception.class})
    @RequestMapping(value={"resultList-update"}, method={RequestMethod.GET})
    @ResponseBody
    public void springPaginationDataTablesUpdate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ObjectType objectType;
        Long positionId = 0L;
        Long complaintTypeId = 0L;
        ComplaintType complaintType = null;
        String complaintTypeCode = null;
        if (request.getParameter("positionId") != null && !"".equals(request.getParameter("positionId"))) {
            positionId = Long.valueOf(request.getParameter("positionId"));
        }
        if (request.getParameter("complaintTypeId") != null && !"".equals(request.getParameter("complaintTypeId")) && (complaintType = this.complaintTypeService.findBy(complaintTypeId = Long.valueOf(request.getParameter("complaintTypeId")))) != null) {
            complaintTypeCode = complaintType.getCode();
        }
        if ((objectType = this.objectTypeService.getObjectTypeByName("Complaint")) != null) {
            String escalationTimeRouterJSONData = this.commonSearchResult(positionId, complaintTypeCode, objectType.getId());
            response.setContentType(CONTENTTYPE_JSON);
            IOUtils.write((String)escalationTimeRouterJSONData, (Writer)response.getWriter());
        }
    }

    public String commonSearchResult(Long positionId, String complaintTypeCode, Integer objectId) {
        ArrayList<EscalationHelper> escalationHelperList = new ArrayList<EscalationHelper>();
        List pageOfEscalation = this.positionHierarchyService.getListOfPositionHeirarchyByFromPositionAndObjectTypeAndSubType(positionId, objectId, complaintTypeCode);
        for (PositionHierarchy posHir : pageOfEscalation) {
            EscalationHelper escalationHelper = new EscalationHelper();
            if (posHir.getObjectSubType() != null) {
                escalationHelper.setComplaintType(this.complaintTypeService.findByCode(posHir.getObjectSubType()));
            }
            escalationHelper.setFromPosition(posHir.getFromPosition());
            escalationHelper.setToPosition(posHir.getToPosition());
            escalationHelperList.add(escalationHelper);
        }
        return "{ \"data\":" + this.toJSON(escalationHelperList) + "}";
    }

    private String toJSON(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(EscalationHelper.class, (Object)new EscalationHelperAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

