/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.complaint;

import java.util.List;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.pgr.entity.Complaint;
import org.egov.pgr.service.ComplaintService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class ViewComplaintController {
    private ComplaintService complaintService;

    @Autowired
    public ViewComplaintController(ComplaintService complaintService) {
        this.complaintService = complaintService;
    }

    @RequestMapping(value={"/complaint/view/{crnNo}"}, method={RequestMethod.GET})
    public String viewComplaints(@PathVariable String crnNo, Model model) {
        Complaint complaint = this.complaintService.getComplaintByCRN(crnNo);
        if (complaint == null) {
            throw new ApplicationRuntimeException("PGR.002");
        }
        List historyTable = this.complaintService.getHistory(complaint);
        model.addAttribute("complaintHistory", (Object)historyTable);
        model.addAttribute("complaint", (Object)complaint);
        return "view-complaint";
    }
}

