/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.masters;

import java.util.List;
import javax.validation.Valid;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.pgr.entity.ComplaintRouter;
import org.egov.pgr.service.ComplaintRouterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/router"})
class UpdateRouterController {
    private final BoundaryTypeService boundaryTypeService;
    private final ComplaintRouterService complaintRouterService;

    @Autowired
    public UpdateRouterController(BoundaryTypeService boundaryTypeService, ComplaintRouterService complaintRouterService) {
        this.boundaryTypeService = boundaryTypeService;
        this.complaintRouterService = complaintRouterService;
    }

    @ModelAttribute(value="boundaryTypes")
    public List<BoundaryType> boundaryTypes() {
        return this.boundaryTypeService.getBoundaryTypeByHierarchyTypeName("ADMINISTRATION");
    }

    @ModelAttribute
    public ComplaintRouter complaintRouter(@PathVariable Long id) {
        return this.complaintRouterService.getRouterById(id);
    }

    @RequestMapping(value={"/update/{id}"}, method={RequestMethod.GET})
    public String updateRouterForm(Model model, @PathVariable Long id) {
        return "router-update";
    }

    @RequestMapping(value={"/search/update/{id}"}, method={RequestMethod.GET})
    public String updatefromSearchRouterForm(Model model, @PathVariable Long id) {
        return "router-updateSearch";
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String viewRouterForm(Model model, @PathVariable Long id) {
        return "router-view";
    }

    @RequestMapping(value={"/update/{id}"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute ComplaintRouter complaintRouter, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (errors.hasErrors()) {
            return "router-update";
        }
        this.complaintRouterService.updateComplaintRouter(complaintRouter);
        redirectAttrs.addFlashAttribute("complaintRouter", (Object)complaintRouter);
        model.addAttribute("routerHeading", (Object)"msg.router.update.heading");
        model.addAttribute("message", (Object)"msg.router.update.success");
        return "router-success";
    }

    @RequestMapping(value={"/search/update/{id}"}, method={RequestMethod.POST})
    public String searchupdate(@Valid @ModelAttribute ComplaintRouter complaintRouter, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (errors.hasErrors()) {
            return "router-updateSearch";
        }
        this.complaintRouterService.updateComplaintRouter(complaintRouter);
        redirectAttrs.addFlashAttribute("complaintRouter", (Object)complaintRouter);
        model.addAttribute("routerHeading", (Object)"msg.router.update.heading");
        model.addAttribute("message", (Object)"msg.router.update.success");
        return "router-updateSuccess";
    }

    @RequestMapping(value={"/delete/{id}"}, method={RequestMethod.POST})
    public String delete(@Valid @ModelAttribute ComplaintRouter complaintRouter, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (errors.hasErrors()) {
            return "router-update";
        }
        this.complaintRouterService.deleteComplaintRouter(complaintRouter);
        redirectAttrs.addFlashAttribute("complaintRouter", (Object)complaintRouter);
        model.addAttribute("routerHeading", (Object)"msg.router.del.heading");
        model.addAttribute("message", (Object)"msg.router.del.success");
        return "router-deleteMsg";
    }
}

