/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.config.search.Index;
import org.egov.config.search.IndexType;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.web.support.json.adapter.HibernateProxyTypeAdapter;
import org.egov.infstr.services.EISServeable;
import org.egov.pgr.entity.Complaint;
import org.egov.pgr.entity.ComplaintRestAdaptor;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.entity.ComplaintTypeRestAdaptor;
import org.egov.pgr.entity.RestComplaint;
import org.egov.pgr.service.ComplaintStatusService;
import org.egov.pgr.web.contract.ComplaintSearchRequest;
import org.egov.pgr.web.controller.complaint.GenericComplaintController;
import org.egov.search.domain.Page;
import org.egov.search.domain.SearchResult;
import org.egov.search.domain.Sort;
import org.egov.search.service.SearchService;
import org.jfree.util.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RestComplaintController
extends GenericComplaintController {
    private static final Logger LOG = LoggerFactory.getLogger(RestComplaintController.class);
    @Autowired
    protected ComplaintStatusService complaintStatusService;
    @Autowired
    private EISServeable eisService;
    @Autowired
    private UserService userService;
    @Autowired
    private SearchService searchService;
    @Autowired
    private MessageSource messageSource;

    @RequestMapping(value={"rest/showAllcomplaint"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public String testInstances(@RequestBody ComplaintSearchRequest searchRequest) {
        SearchResult searchResult = this.searchService.search(Arrays.asList(Index.PGR.toString()), Arrays.asList(IndexType.COMPLAINT.toString()), searchRequest.searchQuery(), searchRequest.searchFilters(), Sort.NULL, Page.NULL);
        List documents = searchResult.getDocuments();
        Gson jsonCreator = new GsonBuilder().registerTypeAdapterFactory(HibernateProxyTypeAdapter.FACTORY).disableHtmlEscaping().create();
        String json = jsonCreator.toJson((Object)documents, new /* Unavailable Anonymous Inner Class!! */.getType());
        return json;
    }

    @RequestMapping(value={"rest/complaintTypes"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String getAllComplaintTypes() {
        List complaintTypes = this.complaintTypeService.findAll();
        Gson jsonCreator = new GsonBuilder().registerTypeAdapterFactory(HibernateProxyTypeAdapter.FACTORY).disableHtmlEscaping().registerTypeAdapter(ComplaintType.class, (Object)new ComplaintTypeRestAdaptor()).create();
        String json = jsonCreator.toJson((Object)complaintTypes, new /* Unavailable Anonymous Inner Class!! */.getType());
        return json;
    }

    @RequestMapping(value={"rest/complaint"}, method={RequestMethod.POST})
    @ResponseBody
    public String createComplaints(@RequestBody Complaint complaint) {
        String json = "";
        try {
            if (complaint != null) {
                if (complaint.getComplaintType() != null && complaint.getComplaintType().getCode() != null) {
                    complaint.setComplaintType(this.complaintTypeService.findByCode(complaint.getComplaintType().getCode()));
                }
                if (complaint.getReceivingCenter() != null && complaint.getReceivingCenter().getName() != null) {
                    complaint.setReceivingCenter(this.receivingCenterService.findByName(complaint.getReceivingCenter().getName()));
                }
            }
            this.complaintService.createComplaint(complaint);
            Gson jsonCreator = new GsonBuilder().registerTypeAdapterFactory(HibernateProxyTypeAdapter.FACTORY).disableHtmlEscaping().registerTypeAdapter(Complaint.class, (Object)new ComplaintRestAdaptor()).create();
            json = jsonCreator.toJson((Object)complaint, new /* Unavailable Anonymous Inner Class!! */.getType());
        }
        catch (Exception e) {
            Log.error((Object)("Error deserializing note " + complaint), (Exception)e);
        }
        return json;
    }

    @RequestMapping(value={"rest/complaint/{complaintno}"}, method={RequestMethod.PUT})
    @ResponseBody
    public String putComputer(@PathVariable String complaintno, @RequestBody RestComplaint restComplaint, HttpServletRequest request) {
        Complaint complaint = this.complaintService.getComplaintByCRN(complaintno);
        Long approvalPosition = 0L;
        Long userId = 0L;
        if (restComplaint.getApprovalUserName() != null && (userId = this.userService.getUserByUsername(restComplaint.getApprovalUserName()).getId()) != 0L) {
            approvalPosition = this.eisService.getPrimaryPositionForUser(userId, new Date()).getId();
        }
        String approvalComent = "";
        if (null != restComplaint.getApprovalComment()) {
            approvalComent = restComplaint.getApprovalComment();
        }
        String status = "";
        if (null != restComplaint.getStatus()) {
            status = restComplaint.getStatus();
            complaint.setStatus(this.complaintStatusService.getByName(status));
        }
        complaint = this.complaintService.update(complaint, approvalPosition, approvalComent);
        String fwdmsg = this.messageSource.getMessage("msg.comp.fwd.usr", (Object[])new String[]{complaintno, restComplaint.getStatus(), restComplaint.getApprovalUserName()}, null);
        return fwdmsg;
    }
}

