/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.complaint;

import java.util.Arrays;
import java.util.List;
import org.egov.config.search.Index;
import org.egov.config.search.IndexType;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.pgr.entity.ComplaintStatus;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.service.ComplaintService;
import org.egov.pgr.service.ComplaintStatusService;
import org.egov.pgr.service.ComplaintTypeService;
import org.egov.pgr.web.contract.ComplaintSearchRequest;
import org.egov.search.domain.Document;
import org.egov.search.domain.Page;
import org.egov.search.domain.SearchResult;
import org.egov.search.domain.Sort;
import org.egov.search.service.SearchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ComplaintSearchController {
    private final SearchService searchService;
    private final ComplaintService complaintService;
    private final ComplaintStatusService complaintStatusService;
    private final AssignmentService assignmentService;
    private final DepartmentService departmentService;
    private final SecurityUtils securityUtils;
    private static final Logger logger = LoggerFactory.getLogger(ComplaintSearchController.class);
    @Autowired
    private final CityService cityService;
    private final ComplaintTypeService complaintTypeService;

    @Autowired
    public ComplaintSearchController(SearchService searchService, ComplaintService complaintService, ComplaintStatusService complaintStatusService, ComplaintTypeService complaintTypeService, AssignmentService assignmentService, SecurityUtils securityUtils, CityService cityService, DepartmentService departmentService) {
        this.searchService = searchService;
        this.complaintService = complaintService;
        this.complaintStatusService = complaintStatusService;
        this.assignmentService = assignmentService;
        this.securityUtils = securityUtils;
        this.cityService = cityService;
        this.departmentService = departmentService;
        this.complaintTypeService = complaintTypeService;
    }

    @ModelAttribute(value="complaintTypedropdown")
    public List<ComplaintType> complaintTypes() {
        return this.complaintTypeService.findActiveComplaintTypes();
    }

    @ModelAttribute(value="complaintTypeDepartments")
    public List<Department> complaintTypeDepartments() {
        return this.departmentService.getAllDepartments();
    }

    @ModelAttribute(value="complaintStatuses")
    public List<ComplaintStatus> complaintStatuses() {
        return this.complaintStatusService.getAllComplaintStatus();
    }

    @ModelAttribute(value="complaintReceivingModes")
    public List complaintReceivingModes() {
        return this.complaintService.getAllReceivingModes();
    }

    @ModelAttribute(value="currentLoggedUser")
    public String currentLoggedUser() {
        User user = this.securityUtils.getCurrentUser();
        if (null != user) {
            return this.securityUtils.getCurrentUser().getUsername();
        }
        return "";
    }

    @ModelAttribute(value="isGrievanceOfficer")
    public Boolean validateForGo() {
        Boolean isGoRole = Boolean.FALSE;
        User user = this.securityUtils.getCurrentUser();
        if (null != user) {
            for (Role role : user.getRoles()) {
                if (!"Grievance Officer".equalsIgnoreCase(role.getName())) continue;
                isGoRole = Boolean.TRUE;
                break;
            }
        }
        return isGoRole;
    }

    @ModelAttribute(value="employeeposition")
    public Long employeePosition() {
        logger.debug("User is :" + this.currentLoggedUser());
        User user = this.securityUtils.getCurrentUser();
        if (null != user) {
            logger.debug("Assignment" + this.assignmentService.getAllActiveEmployeeAssignmentsByEmpId(this.securityUtils.getCurrentUser().getId()).size());
            if (this.assignmentService.getAllActiveEmployeeAssignmentsByEmpId(user.getId()).size() < 1) {
                return 0L;
            }
            logger.debug("Position " + ((Assignment)this.assignmentService.getAllActiveEmployeeAssignmentsByEmpId(user.getId()).get(0)).getPosition().getId());
            return ((Assignment)this.assignmentService.getAllActiveEmployeeAssignmentsByEmpId(user.getId()).get(0)).getPosition().getId();
        }
        return 0L;
    }

    @ModelAttribute
    public ComplaintSearchRequest searchRequest() {
        return new ComplaintSearchRequest();
    }

    @ModelAttribute(value="currentUlb")
    public String getCurrentUlb() {
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        if (null != cityWebsite) {
            logger.debug("logged in as " + cityWebsite.getName());
            return cityWebsite.getName();
        }
        return "";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/complaint/search"})
    public String showSearchFormOffical() {
        return "complaint-search";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/complaint/citizen/anonymous/search"})
    public String showSearchFormCitizen() {
        return "complaint-search";
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/complaint/search"})
    @ResponseBody
    public List<Document> searchComplaintsOffical(@ModelAttribute ComplaintSearchRequest searchRequest) {
        SearchResult searchResult = null;
        searchResult = this.searchService.search(Arrays.asList(Index.PGR.toString()), Arrays.asList(IndexType.COMPLAINT.toString()), searchRequest.searchQuery(), searchRequest.searchFilters(), Sort.NULL, Page.NULL);
        return searchResult.getDocuments();
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/complaint/citizen/anonymous/search"})
    @ResponseBody
    public List<Document> searchComplaintsCitizen(@ModelAttribute ComplaintSearchRequest searchRequest) {
        SearchResult searchResult = this.searchService.search(Arrays.asList(Index.PGR.toString()), Arrays.asList(IndexType.COMPLAINT.toString()), searchRequest.searchQuery(), searchRequest.searchFilters(), Sort.NULL, Page.NULL);
        return searchResult.getDocuments();
    }
}

