/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.contract;

import java.util.ArrayList;
import org.egov.infra.utils.DateUtils;
import org.egov.search.domain.Filter;
import org.egov.search.domain.Filters;
import org.joda.time.DateTime;

public class ComplaintSearchRequest {
    public static final String SEARCH_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm";
    private String searchText;
    private String complaintNumber;
    private String complainantName;
    private String complaintStatus;
    private String complainantPhoneNumber;
    private String complainantEmail;
    private String receivingCenter;
    private String complaintType;
    private String complaintDateFrom;
    private String complaintDateTo;
    private String fromDate;
    private String toDate;
    private String complaintDepartment;
    private String location;
    private String currentUlb;

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public void setComplaintNumber(String complaintNumber) {
        this.complaintNumber = complaintNumber;
    }

    public void setCurrentUlb(String currentUlb) {
        this.currentUlb = currentUlb;
    }

    public void setComplaintStatus(String complaintStatus) {
        this.complaintStatus = complaintStatus;
    }

    public void setComplainantName(String complainantName) {
        this.complainantName = complainantName;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setComplainantPhoneNumber(String phoneNumber) {
        this.complainantPhoneNumber = phoneNumber;
    }

    public void setComplainantEmail(String email) {
        this.complainantEmail = email;
    }

    public void setReceivingCenter(String receivingCenter) {
        this.receivingCenter = receivingCenter;
    }

    public void setComplaintType(String complaintType) {
        this.complaintType = complaintType;
    }

    public void setFromDate(String fromDate) {
        if (fromDate != null) {
            this.fromDate = DateUtils.startOfGivenDate((DateTime)DateUtils.TO_DEFAULT_DATE_FORMAT.parseDateTime(fromDate)).toString(SEARCH_DATE_FORMAT);
        }
    }

    public void setToDate(String toDate) {
        if (toDate != null) {
            this.toDate = DateUtils.endOfGivenDate((DateTime)DateUtils.TO_DEFAULT_DATE_FORMAT.parseDateTime(toDate)).toString(SEARCH_DATE_FORMAT);
        }
    }

    public void setComplaintDepartment(String complaintDepartment) {
        this.complaintDepartment = complaintDepartment;
    }

    public void setComplaintDate(String complaintDate) {
        if (null != complaintDate) {
            DateTime currentDate = new DateTime();
            this.complaintDateTo = DateUtils.endOfGivenDate((DateTime)currentDate).toString(SEARCH_DATE_FORMAT);
            if (complaintDate.equalsIgnoreCase("today")) {
                this.complaintDateFrom = currentDate.withTimeAtStartOfDay().toString(SEARCH_DATE_FORMAT);
            } else if (complaintDate.equalsIgnoreCase("all")) {
                this.complaintDateFrom = null;
                this.complaintDateTo = null;
            } else if (complaintDate.equalsIgnoreCase("lastsevendays")) {
                this.complaintDateFrom = currentDate.minusDays(7).toString(SEARCH_DATE_FORMAT);
            } else if (complaintDate.equalsIgnoreCase("lastthirtydays")) {
                this.complaintDateFrom = currentDate.minusDays(30).toString(SEARCH_DATE_FORMAT);
            } else if (complaintDate.equalsIgnoreCase("lastninetydays")) {
                this.complaintDateFrom = currentDate.minusDays(90).toString(SEARCH_DATE_FORMAT);
            } else {
                this.complaintDateFrom = null;
                this.complaintDateTo = null;
            }
        }
    }

    public Filters searchFilters() {
        ArrayList<Filter> andFilters = new ArrayList<Filter>();
        andFilters.add(Filter.termsStringFilter((String)"clauses.citydetails.name", (String[])new String[]{this.currentUlb}));
        andFilters.add(Filter.termsStringFilter((String)"clauses.crn", (String[])new String[]{this.complaintNumber}));
        andFilters.add(Filter.queryStringFilter((String)"common.citizen.name", (String)this.complainantName));
        andFilters.add(Filter.queryStringFilter((String)"common.citizen.mobile", (String)this.complainantPhoneNumber));
        andFilters.add(Filter.queryStringFilter((String)"common.citizen.email", (String)this.complainantEmail));
        andFilters.add(Filter.queryStringFilter((String)"clauses.status.name", (String)this.complaintStatus));
        andFilters.add(Filter.queryStringFilter((String)"clauses.receivingMode", (String)this.receivingCenter));
        andFilters.add(Filter.queryStringFilter((String)"searchable.complaintType.name", (String)this.complaintType));
        andFilters.add(Filter.rangeFilter((String)"common.createdDate", (String)this.complaintDateFrom, (String)this.complaintDateTo));
        andFilters.add(Filter.rangeFilter((String)"common.createdDate", (String)this.fromDate, (String)this.toDate));
        andFilters.add(Filter.termsStringFilter((String)"clauses.department.name", (String[])new String[]{this.complaintDepartment}));
        andFilters.add(Filter.queryStringFilter((String)"common.boundary.name", (String)this.location));
        return Filters.withAndFilters(andFilters);
    }

    public String searchQuery() {
        return this.searchText;
    }
}

