/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.reports;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.infra.web.utils.WebUtils;
import org.egov.pgr.service.reports.FunctionaryWiseReportService;
import org.egov.pgr.web.controller.reports.DrillDownReportHelperAdaptor;
import org.egov.pgr.web.controller.reports.DrillDownReportResult;
import org.egov.pgr.web.controller.reports.DrillDownReportWithcompTypeAdaptor;
import org.egov.pgr.web.controller.reports.ReportHelper;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/functionaryWiseReport"})
public class FunctionaryWiseReportController {
    private final FunctionaryWiseReportService functionaryWiseReportService;

    @Autowired
    public FunctionaryWiseReportController(FunctionaryWiseReportService functionaryWiseReportService) {
        this.functionaryWiseReportService = functionaryWiseReportService;
    }

    @ModelAttribute
    public void getReportHelper(Model model) {
        model.addAttribute("reportHelper", (Object)new ReportHelper());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/search"})
    public String searchAgeingReportByBoundaryForm(Model model) {
        return "functionaryWise-search";
    }

    @ExceptionHandler(value={Exception.class})
    @RequestMapping(value={"/result"}, method={RequestMethod.GET})
    @ResponseBody
    public void result(@RequestParam String usrid, @RequestParam String status, @RequestParam String complaintDateType, @RequestParam DateTime fromDate, @RequestParam DateTime toDate, HttpServletRequest request, HttpServletResponse response) throws IOException {
        SQLQuery functionaryReportQuery = null;
        List functionaryReportResult = null;
        String result = null;
        if (usrid != null && status != null && !"".equals(usrid) && !"".equals(status)) {
            functionaryReportQuery = this.functionaryWiseReportService.getFunctionaryWiseReportQuery(fromDate, toDate, usrid, complaintDateType, status);
            functionaryReportQuery.setResultTransformer(Transformers.aliasToBean(DrillDownReportResult.class));
            functionaryReportResult = functionaryReportQuery.list();
            result = "{ \"data\":" + WebUtils.toJSON((Collection)functionaryReportResult, DrillDownReportResult.class, DrillDownReportWithcompTypeAdaptor.class) + "}";
        } else {
            functionaryReportQuery = this.functionaryWiseReportService.getFunctionaryWiseReportQuery(fromDate, toDate, usrid, complaintDateType);
            functionaryReportQuery.setResultTransformer(Transformers.aliasToBean(DrillDownReportResult.class));
            functionaryReportResult = functionaryReportQuery.list();
            result = "{ \"data\":" + WebUtils.toJSON((Collection)functionaryReportResult, DrillDownReportResult.class, DrillDownReportHelperAdaptor.class) + "}";
        }
        response.setContentType("application/json");
        IOUtils.write((String)result, (Writer)response.getWriter());
    }
}

