/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.dashboard.es;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.entity.es.ComplaintDashBoardRequest;
import org.egov.pgr.service.ComplaintTypeService;
import org.egov.pgr.service.es.ComplaintIndexService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/complaint/aggregate"})
public class ComplaintIndexController {
    @Autowired
    private ComplaintIndexService complaintIndexService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private ComplaintTypeService complaintTypeService;
    @Autowired
    private BoundaryService boundaryService;

    @RequestMapping(value={"/grievance"}, method={RequestMethod.POST}, produces={"application/json"})
    public Map<String, Object> getDashBoardResponse(@RequestBody ComplaintDashBoardRequest complaintRequest) {
        return this.complaintIndexService.getGrievanceReport(complaintRequest);
    }

    @RequestMapping(value={"/grievance/complainttype"}, method={RequestMethod.POST}, produces={"application/json"})
    public Map<String, Object> getGrievanceComplaintTypeResponse(@RequestBody ComplaintDashBoardRequest complaintRequest) {
        return this.complaintIndexService.getComplaintTypeReport(complaintRequest);
    }

    @RequestMapping(value={"/sourcewisegrievance"}, method={RequestMethod.POST}, produces={"application/json"})
    public Map<String, Object> getSourceWiseGrievanceResponse(@RequestBody ComplaintDashBoardRequest complaintRequest) {
        return this.complaintIndexService.getSourceWiseResponse(complaintRequest);
    }

    @RequestMapping(value={"/departments"}, method={RequestMethod.POST}, produces={"application/json"})
    public List<JSONObject> getDepartments() {
        List departments = this.departmentService.getAllDepartments();
        ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>();
        for (Department department : departments) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"name", (Object)department.getName());
            jsonObject.put((Object)"code", (Object)department.getCode());
            jsonList.add(jsonObject);
        }
        return jsonList;
    }

    @RequestMapping(value={"/complainttypes"}, method={RequestMethod.POST}, produces={"application/json"})
    public List<JSONObject> getComplaintTypes() {
        List complaintTypeList = this.complaintTypeService.findAll();
        ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>();
        for (ComplaintType complaintType : complaintTypeList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"name", (Object)complaintType.getName());
            jsonObject.put((Object)"code", (Object)complaintType.getCode());
            jsonList.add(jsonObject);
        }
        return jsonList;
    }

    @RequestMapping(value={"/wards"}, method={RequestMethod.POST}, produces={"application/json"})
    public List<JSONObject> getWards() {
        List boundaryList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "ADMINISTRATION");
        ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>();
        for (Boundary boundary : boundaryList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"name", (Object)boundary.getName());
            jsonObject.put((Object)"boundaryNumber", (Object)boundary.getBoundaryNum());
            jsonObject.put((Object)"lat", (Object)boundary.getLatitude());
            jsonObject.put((Object)"lon", (Object)boundary.getLongitude());
            jsonList.add(jsonObject);
        }
        return jsonList;
    }

    @RequestMapping(value={"/sourcenames"}, method={RequestMethod.POST}, produces={"application/json"})
    public List<String> getSourceNameList() throws JsonProcessingException {
        return this.complaintIndexService.getSourceNameList();
    }
}

