/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.complaint;

import java.util.List;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.pgr.entity.ComplaintStatus;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.entity.es.ComplaintIndex;
import org.egov.pgr.service.ComplaintService;
import org.egov.pgr.service.ComplaintStatusService;
import org.egov.pgr.service.ComplaintTypeService;
import org.egov.pgr.service.es.ComplaintIndexService;
import org.egov.pgr.web.contract.ComplaintSearchRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ComplaintSearchController {
    @Autowired
    private ComplaintService complaintService;
    @Autowired
    private ComplaintStatusService complaintStatusService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private ComplaintTypeService complaintTypeService;
    @Autowired
    private ComplaintIndexService complaintIndexService;

    @ModelAttribute(value="complaintTypedropdown")
    public List<ComplaintType> complaintTypes() {
        return this.complaintTypeService.findActiveComplaintTypes();
    }

    @ModelAttribute(value="complaintTypeDepartments")
    public List<Department> complaintTypeDepartments() {
        return this.departmentService.getAllDepartments();
    }

    @ModelAttribute(value="complaintStatuses")
    public List<ComplaintStatus> complaintStatuses() {
        return this.complaintStatusService.getAllComplaintStatus();
    }

    @ModelAttribute(value="complaintReceivingModes")
    public List complaintReceivingModes() {
        return this.complaintService.getAllReceivingModes();
    }

    @ModelAttribute(value="currentLoggedUser")
    public String currentLoggedUser() {
        User user = this.securityUtils.getCurrentUser();
        return user != null ? user.getUsername() : "";
    }

    @ModelAttribute(value="isGrievanceOfficer")
    public Boolean validateForGo() {
        User user = this.securityUtils.getCurrentUser();
        if (user != null) {
            for (Role role : user.getRoles()) {
                if (!"Grievance Officer".equalsIgnoreCase(role.getName())) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    @ModelAttribute(value="employeeposition")
    public Long employeePosition() {
        User user = this.securityUtils.getCurrentUser();
        return user != null && !this.assignmentService.getAllActiveEmployeeAssignmentsByEmpId(user.getId()).isEmpty() ? ((Assignment)this.assignmentService.getAllActiveEmployeeAssignmentsByEmpId(user.getId()).get(0)).getPosition().getId() : 0L;
    }

    @ModelAttribute
    public ComplaintSearchRequest searchRequest() {
        return new ComplaintSearchRequest();
    }

    @ModelAttribute(value="currentUlb")
    public String getCurrentUlb() {
        return ApplicationThreadLocals.getCityName();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/complaint/search", "/complaint/citizen/anonymous/search"})
    public String showSearch() {
        return "complaint-search";
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/complaint/search", "/complaint/citizen/anonymous/search"})
    @ResponseBody
    public Iterable<ComplaintIndex> searchComplaints(@ModelAttribute ComplaintSearchRequest searchRequest) {
        return this.complaintIndexService.searchComplaintIndex(searchRequest.prepareSearchQuery());
    }
}

