/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.contract;

import org.apache.commons.lang3.StringUtils;
import org.egov.infra.utils.DateUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.joda.time.DateTime;

public class ComplaintSearchRequest {
    private String searchText;
    private String complaintNumber;
    private String complainantName;
    private String complaintStatus;
    private String complainantPhoneNumber;
    private String complainantEmail;
    private String receivingCenter;
    private String complaintType;
    private String complaintDateFrom;
    private String complaintDateTo;
    private String fromDate;
    private String toDate;
    private String complaintDepartment;
    private String location;
    private String currentUlb;

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public void setComplaintNumber(String complaintNumber) {
        this.complaintNumber = complaintNumber;
    }

    public void setCurrentUlb(String currentUlb) {
        this.currentUlb = currentUlb;
    }

    public void setComplaintStatus(String complaintStatus) {
        this.complaintStatus = complaintStatus;
    }

    public void setComplainantName(String complainantName) {
        this.complainantName = complainantName;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setComplainantPhoneNumber(String phoneNumber) {
        this.complainantPhoneNumber = phoneNumber;
    }

    public void setComplainantEmail(String email) {
        this.complainantEmail = email;
    }

    public void setReceivingCenter(String receivingCenter) {
        this.receivingCenter = receivingCenter;
    }

    public void setComplaintType(String complaintType) {
        this.complaintType = complaintType;
    }

    public void setFromDate(String fromDate) {
        if (fromDate != null) {
            this.fromDate = DateUtils.startOfGivenDate((DateTime)DateUtils.TO_DEFAULT_DATE_FORMAT.parseDateTime(fromDate)).toString("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        }
    }

    public void setToDate(String toDate) {
        if (toDate != null) {
            this.toDate = DateUtils.endOfGivenDate((DateTime)DateUtils.TO_DEFAULT_DATE_FORMAT.parseDateTime(toDate)).toString("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        }
    }

    public void setComplaintDepartment(String complaintDepartment) {
        this.complaintDepartment = complaintDepartment;
    }

    public void setComplaintDate(String complaintDate) {
        if (null != complaintDate) {
            DateTime currentDate = new DateTime();
            this.toDate = DateUtils.endOfGivenDate((DateTime)currentDate).toString("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            if ("today".equalsIgnoreCase(complaintDate)) {
                this.fromDate = currentDate.withTimeAtStartOfDay().toString("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            } else if ("all".equalsIgnoreCase(complaintDate)) {
                this.fromDate = null;
                this.toDate = null;
            } else if ("lastsevendays".equalsIgnoreCase(complaintDate)) {
                this.fromDate = currentDate.minusDays(7).toString("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            } else if ("lastthirtydays".equalsIgnoreCase(complaintDate)) {
                this.fromDate = currentDate.minusDays(30).toString("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            } else if ("lastninetydays".equalsIgnoreCase(complaintDate)) {
                this.fromDate = currentDate.minusDays(90).toString("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            } else {
                this.fromDate = null;
                this.toDate = null;
            }
        }
    }

    public BoolQueryBuilder prepareSearchQuery() {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchAllQuery());
        if (StringUtils.isNotBlank((CharSequence)this.complaintNumber)) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"crn", (Object)this.complaintNumber));
        }
        if (StringUtils.isNotBlank((CharSequence)this.complainantName)) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"complainantName", (Object)this.complainantName));
        }
        if (StringUtils.isNotBlank((CharSequence)this.complainantPhoneNumber)) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"complainantMobile", (Object)this.complainantPhoneNumber));
        }
        if (StringUtils.isNotBlank((CharSequence)this.complainantEmail)) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"complainantEmail", (Object)this.complainantEmail));
        }
        if (StringUtils.isNotBlank((CharSequence)this.complaintType)) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"complaintTypeName", (Object)this.complaintType));
        }
        if (StringUtils.isNotBlank((CharSequence)this.complaintDepartment)) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"departmentName", (Object)this.complaintDepartment));
        }
        if (StringUtils.isNotBlank((CharSequence)this.complaintStatus)) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"complaintStatusName", (Object)this.complaintStatus));
        }
        if (StringUtils.isNotBlank((CharSequence)this.receivingCenter)) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"receivingMode", (Object)this.receivingCenter));
        }
        if (StringUtils.isNotBlank((CharSequence)this.location)) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"wardName", (Object)this.location));
        }
        if (StringUtils.isNotBlank((CharSequence)this.fromDate) || StringUtils.isNotBlank((CharSequence)this.toDate)) {
            boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"createdDate").from(this.fromDate).to(this.toDate));
        }
        return boolQuery;
    }
}

