/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.reports;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.pgr.entity.Complaint;
import org.egov.pgr.service.ComplaintService;
import org.egov.pgr.web.controller.reports.PendingGrievanceAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/pending"})
public class PendingGrievanceController {
    private final ComplaintService complaintService;
    public static final String CONTENTTYPE_JSON = "application/json";

    @Autowired
    public PendingGrievanceController(ComplaintService complaintService) {
        this.complaintService = complaintService;
    }

    @ModelAttribute
    public Complaint complaint() {
        return new Complaint();
    }

    @RequestMapping(value={"/grievance-list"}, method={RequestMethod.GET})
    public String complaintTypeViewForm() {
        return "grievance-list";
    }

    @RequestMapping(value={"/ajax-grievancelist"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void getPendingGrievances(HttpServletRequest request, HttpServletResponse response) throws IOException {
        IOUtils.write((String)("{ \"data\":" + this.toJSON((Object)this.complaintService.getPendingGrievances()) + "}"), (Writer)response.getWriter());
    }

    private String toJSON(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(Complaint.class, (Object)new PendingGrievanceAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

