/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.reports;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.pgr.service.ComplaintTypeService;
import org.egov.pgr.service.reports.ComplaintTypeWiseReportService;
import org.egov.pgr.web.controller.reports.DrillDownReportHelperAdaptor;
import org.egov.pgr.web.controller.reports.DrillDownReportResult;
import org.egov.pgr.web.controller.reports.DrillDownReportWithcompTypeAdaptor;
import org.egov.pgr.web.controller.reports.ReportHelper;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report"})
public class ComplaintTypeWiseReportController {
    private final ComplaintTypeWiseReportService complaintTypeReportService;

    @Autowired
    public ComplaintTypeWiseReportController(ComplaintTypeWiseReportService complaintTypeReportService, ComplaintTypeService complaintTypeService) {
        this.complaintTypeReportService = complaintTypeReportService;
    }

    @ModelAttribute
    public void getReportHelper(Model model) {
        model.addAttribute("reportHelper", (Object)new ReportHelper());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/complaintTypeReport"})
    public String searchAgeingReportByBoundaryForm(Model model) {
        return "complaintTypeReport-search";
    }

    @ExceptionHandler(value={Exception.class})
    @RequestMapping(value={"/complaintTypeReport/resultList-update"}, method={RequestMethod.GET})
    @ResponseBody
    public void springPaginationDataTablesUpdate(@RequestParam String complaintType, @RequestParam String complaintTypeWithStatus, @RequestParam String status, @RequestParam String complaintDateType, @RequestParam DateTime fromDate, @RequestParam DateTime toDate, HttpServletRequest request, HttpServletResponse response) throws IOException {
        SQLQuery complaintTypeReportQuery = null;
        List complaintTypeReportResult = null;
        String result = null;
        if (complaintTypeWithStatus != null && status != null && !"".equals(complaintTypeWithStatus) && !"".equals(status)) {
            complaintTypeReportQuery = this.complaintTypeReportService.getComplaintTypeWiseReportQuery(fromDate, toDate, complaintDateType, complaintTypeWithStatus, status);
            complaintTypeReportQuery.setResultTransformer(Transformers.aliasToBean(DrillDownReportResult.class));
            complaintTypeReportResult = complaintTypeReportQuery.list();
            result = "{ \"data\":" + this.toJSONForComplaintType((Object)complaintTypeReportResult) + "}";
        } else {
            complaintTypeReportQuery = this.complaintTypeReportService.getComplaintTypeWiseReportQuery(fromDate, toDate, complaintType, complaintDateType);
            complaintTypeReportQuery.setResultTransformer(Transformers.aliasToBean(DrillDownReportResult.class));
            complaintTypeReportResult = complaintTypeReportQuery.list();
            result = "{ \"data\":" + this.toJSON((Object)complaintTypeReportResult) + "}";
        }
        response.setContentType("application/json");
        IOUtils.write((String)result, (Writer)response.getWriter());
    }

    private Object toJSONForComplaintType(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(DrillDownReportResult.class, (Object)new DrillDownReportWithcompTypeAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }

    private Object toJSON(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(DrillDownReportResult.class, (Object)new DrillDownReportHelperAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

