/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.masters.escalation;

import java.util.ArrayList;
import java.util.List;
import org.egov.commons.ObjectType;
import org.egov.commons.service.ObjectTypeService;
import org.egov.eis.entity.PositionHierarchy;
import org.egov.eis.service.PositionHierarchyService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.service.ComplaintTypeService;
import org.egov.pgr.web.controller.masters.escalationTime.EscalationForm;
import org.egov.pims.commons.Position;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/escalation"})
public class ViewEscalationController {
    public static final String CONTENTTYPE_JSON = "application/json";
    protected final ComplaintTypeService complaintTypeService;
    private final PositionMasterService positionMasterService;
    private final ObjectTypeService objectTypeService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private PositionHierarchyService positionHierarchyService;

    @ModelAttribute
    public EscalationForm escalationForm() {
        return new EscalationForm();
    }

    @ModelAttribute(value="complaintTypes")
    public List<ComplaintType> complaintTypes() {
        return this.complaintTypeService.findAll();
    }

    @ModelAttribute(value="positionMasterList")
    public List<Position> positionMasterList() {
        return this.positionMasterService.getAllPositions();
    }

    @RequestMapping(value={"/search-view"}, method={RequestMethod.GET})
    public String searchEscalationForm(@ModelAttribute EscalationForm escalationForm, Model model) {
        if (escalationForm.getPosition() != null) {
            ObjectType objectType = this.objectTypeService.getObjectTypeByName("Complaint");
            List positionHeirarchyList = this.positionHierarchyService.getPositionHeirarchyByFromPositionAndObjectType(escalationForm.getPosition().getId(), objectType.getId());
            if (positionHeirarchyList.size() > 0) {
                escalationForm.setPositionHierarchyList(positionHeirarchyList);
            } else {
                escalationForm.addPositionHierarchyList(new PositionHierarchy());
                model.addAttribute("mode", (Object)"noDataFound");
            }
        } else {
            escalationForm.addPositionHierarchyList(new PositionHierarchy());
        }
        return "escalation-searchView";
    }

    @RequestMapping(value={"/search-view"}, method={RequestMethod.POST})
    public String searchForm(@ModelAttribute EscalationForm escalationForm, RedirectAttributes redirectAttrs, Model model) {
        if (escalationForm.getPosition() != null && escalationForm.getPosition().getId() != null) {
            ObjectType objectType = this.objectTypeService.getObjectTypeByName("Complaint");
            ArrayList<PositionHierarchy> positionHeirarchyList = this.positionHierarchyService.getPositionHeirarchyByFromPositionAndObjectType(escalationForm.getPosition().getId(), objectType.getId());
            if (positionHeirarchyList.size() > 0) {
                escalationForm.setPositionHierarchyList((List)positionHeirarchyList);
                model.addAttribute("mode", (Object)"dataFound");
            } else {
                positionHeirarchyList = new ArrayList<PositionHierarchy>();
                PositionHierarchy posHierarchy = new PositionHierarchy();
                posHierarchy.setFromPosition(this.positionMasterService.getPositionById(escalationForm.getPosition().getId()));
                posHierarchy.setObjectType(objectType);
                posHierarchy.setObjectSubType("");
                positionHeirarchyList.add(posHierarchy);
                escalationForm.setPositionHierarchyList(positionHeirarchyList);
                model.addAttribute("mode", (Object)"noDataFound");
                model.addAttribute("escalationForm", (Object)escalationForm);
            }
        } else {
            String message = "Position is mandatory. Please enter correct position name.";
            redirectAttrs.addFlashAttribute("escalationForm", (Object)escalationForm);
            model.addAttribute("message", (Object)"Position is mandatory. Please enter correct position name.");
        }
        model.addAttribute("approvalDepartmentList", (Object)this.departmentService.getAllDepartments());
        return "escalation-searchView";
    }

    @Autowired
    public ViewEscalationController(ComplaintTypeService complaintTypeService, PositionMasterService positionMasterService, ObjectTypeService objectTypeService) {
        this.complaintTypeService = complaintTypeService;
        this.positionMasterService = positionMasterService;
        this.objectTypeService = objectTypeService;
    }

    @RequestMapping(value={"/update/{id}"}, method={RequestMethod.POST})
    public String saveEscalationForm(@ModelAttribute EscalationForm escalationForm, Model model, BindingResult errors, RedirectAttributes redirectAttrs, @PathVariable Long id) {
        if (id == null) {
            redirectAttrs.addFlashAttribute("escalationForm", (Object)escalationForm);
            model.addAttribute("message", (Object)"escalation.pos.required");
            return "escalation-searchView";
        }
        ObjectType objectType = this.objectTypeService.getObjectTypeByName("Complaint");
        List existingPosHierarchy = this.positionHierarchyService.getPositionHeirarchyByFromPositionAndObjectType(id, objectType.getId());
        if (existingPosHierarchy != null && existingPosHierarchy.size() > 0) {
            this.positionHierarchyService.deleteAllInBatch(existingPosHierarchy);
        }
        for (PositionHierarchy posHierarchy : escalationForm.getPositionHierarchyList()) {
            if (posHierarchy.getFromPosition() != null && posHierarchy.getFromPosition().getId() != null && posHierarchy.getToPosition() != null && posHierarchy.getToPosition().getId() != null) {
                posHierarchy.setFromPosition(this.positionMasterService.getPositionById(posHierarchy.getFromPosition().getId()));
                posHierarchy.setToPosition(this.positionMasterService.getPositionById(posHierarchy.getToPosition().getId()));
                posHierarchy.setObjectType(objectType);
                posHierarchy.setObjectSubType(posHierarchy.getObjectSubType());
                this.positionHierarchyService.createPositionHierarchy(posHierarchy);
                continue;
            }
            redirectAttrs.addFlashAttribute("escalationForm", (Object)escalationForm);
            model.addAttribute("message", (Object)"escaltion.pos.mandatory");
            return "escalation-searchView";
        }
        redirectAttrs.addFlashAttribute("escalationForm", (Object)escalationForm);
        model.addAttribute("message", (Object)"msg.escaltion.success");
        return "escalation-success";
    }
}

