/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.masters.bulkrouter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.io.IOUtils;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.pgr.entity.ComplaintRouter;
import org.egov.pgr.entity.ComplaintRouterAdaptor;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.entity.ComplaintTypeCategory;
import org.egov.pgr.service.ComplaintRouterService;
import org.egov.pgr.service.ComplaintTypeCategoryService;
import org.egov.pgr.web.controller.masters.bulkrouter.BulkRouterGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/bulkRouter"})
public class BulkRouterGenerationController {
    private final ComplaintRouterService complaintRouterService;
    private final BoundaryTypeService boundaryTypeService;
    private final ComplaintTypeCategoryService complaintTypeCategoryService;

    @Autowired
    public BulkRouterGenerationController(ComplaintRouterService complaintRouterService, BoundaryTypeService boundaryTypeService, ComplaintTypeCategoryService complaintTypeCategoryService) {
        this.complaintRouterService = complaintRouterService;
        this.boundaryTypeService = boundaryTypeService;
        this.complaintTypeCategoryService = complaintTypeCategoryService;
    }

    @ModelAttribute(value="boundaryTypes")
    public List<BoundaryType> boundaryTypes() {
        return this.boundaryTypeService.getBoundaryTypeByHierarchyTypeName("ADMINISTRATION");
    }

    @ModelAttribute(value="categories")
    public List<ComplaintTypeCategory> categories() {
        return this.complaintTypeCategoryService.findAll();
    }

    @ModelAttribute
    public BulkRouterGenerator bulkRouterGenerator() {
        return new BulkRouterGenerator();
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String newform() {
        return "bulkRouter-new";
    }

    @RequestMapping(value={"/search-result"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void search(Model model, HttpServletRequest request, @ModelAttribute BulkRouterGenerator bulkRouterGenerator, HttpServletResponse response) throws IOException {
        List pageOfRouters = this.complaintRouterService.getRoutersByComplaintTypeBoundary(bulkRouterGenerator.getComplaintTypes(), bulkRouterGenerator.getBoundaries());
        String complaintRouterJSONData = "{ \"data\":" + this.toJSON((Object)pageOfRouters) + "}";
        IOUtils.write((String)complaintRouterJSONData, (Writer)response.getWriter());
    }

    private String toJSON(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(ComplaintRouter.class, (Object)new ComplaintRouterAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public String save(@Valid @ModelAttribute BulkRouterGenerator bulkRouterGenerator, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (errors.hasErrors()) {
            model.addAttribute("message", (Object)"router.unble.to.save");
            return "bulkRouter-new";
        }
        for (ComplaintType complaintType : bulkRouterGenerator.getComplaintTypes()) {
            for (Boundary boundary : bulkRouterGenerator.getBoundaries()) {
                ComplaintRouter router = new ComplaintRouter();
                router.setComplaintType(complaintType);
                router.setBoundary(boundary);
                router.setPosition(bulkRouterGenerator.getPosition());
                ComplaintRouter existingRouter = this.complaintRouterService.getExistingRouter(router);
                if (existingRouter != null) {
                    existingRouter.setPosition(bulkRouterGenerator.getPosition());
                    this.complaintRouterService.updateComplaintRouter(existingRouter);
                    continue;
                }
                this.complaintRouterService.createComplaintRouter(router);
            }
        }
        redirectAttrs.addFlashAttribute("message", (Object)"msg.bulkrouter.success");
        return "redirect:/bulkRouter/search";
    }
}

