/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.complaint;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.EmployeeViewService;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CrossHierarchyService;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.entity.ReceivingCenter;
import org.egov.pgr.service.ComplaintTypeService;
import org.egov.pgr.service.ReceivingCenterService;
import org.egov.pims.commons.Designation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/complaint"})
public class GenericComplaintAjaxController {
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private CrossHierarchyService crossHierarchyService;
    @Autowired
    private ReceivingCenterService receivingCenterService;
    @Autowired
    private ComplaintTypeService complaintTypeService;
    @Autowired
    private EmployeeViewService employeeViewService;

    @RequestMapping(value={"citizen/complaintTypes", "citizen/anonymous/complaintTypes", "officials/complaintTypes", "router/complaintTypes", "escalationTime/complaintTypes"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<ComplaintType> getAllActiveComplaintTypesByNameLike(@RequestParam String complaintTypeName) {
        return this.complaintTypeService.findAllActiveByNameLike(complaintTypeName);
    }

    @RequestMapping(value={"citizen/complainttypes-by-category", "citizen/anonymous/complainttypes-by-category", "officials/complainttypes-by-category"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<ComplaintType> complaintTypesByCategory(@RequestParam Long categoryId) {
        return this.complaintTypeService.findActiveComplaintTypesByCategory(categoryId);
    }

    @RequestMapping(value={"pgrreport/complaintTypes", "search/complaintTypes", "search/complaintTypes"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<ComplaintType> getAllComplaintTypesByNameLike(@RequestParam String complaintTypeName) {
        return this.complaintTypeService.findAllByNameLike(complaintTypeName);
    }

    @RequestMapping(value={"escalationTime/ajax-approvalDesignations"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Designation> getAllDesignationsByName(@RequestParam String designationName) {
        return this.designationService.getAllDesignationsByNameLike(designationName);
    }

    @RequestMapping(value={"officials/isCrnRequired"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean isCrnRequired(@RequestParam Long receivingCenterId) {
        ReceivingCenter receivingCenter = this.receivingCenterService.findByRCenterId(receivingCenterId);
        return receivingCenter == null ? Boolean.TRUE.booleanValue() : receivingCenter.isCrnRequired();
    }

    @RequestMapping(value={"citizen/locations", "citizen/anonymous/locations", "officials/locations"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String getAllLocationJSON(@RequestParam String locationName) {
        StringBuilder locationJSONData = new StringBuilder("[");
        String locationNameLike = "%" + locationName + "%";
        this.crossHierarchyService.getChildBoundaryNameAndBndryTypeAndHierarchyType("Locality", "Location", "Administration", locationNameLike).stream().forEach(location -> {
            locationJSONData.append("{\"name\":\"");
            locationJSONData.append(location.getChild().getName() + " - " + location.getParent().getName());
            locationJSONData.append("\",\"id\":").append(location.getId()).append("},");
        });
        if (locationJSONData.lastIndexOf(",") != -1) {
            locationJSONData.deleteCharAt(locationJSONData.lastIndexOf(","));
        }
        locationJSONData.append("]");
        return locationJSONData.toString();
    }

    @RequestMapping(value={"router/position", "escalation/position"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String getAllPositionByNameLike(@RequestParam String positionName, HttpServletResponse response) throws IOException {
        String likePositionName = "%" + positionName.toUpperCase() + "%";
        StringBuilder positionUser = new StringBuilder("[");
        this.employeeViewService.findByUserNameLikeOrCodeLikeOrPosition_NameLike(likePositionName, likePositionName, likePositionName, new Date()).stream().forEach(position -> {
            positionUser.append("{\"name\":\"");
            positionUser.append(position.getPosition().getName() + '-' + position.getName() + '-' + position.getCode());
            positionUser.append("\",\"id\":").append(position.getPosition().getId()).append("},");
        });
        if (positionUser.lastIndexOf(",") != -1) {
            positionUser.deleteCharAt(positionUser.lastIndexOf(","));
        }
        positionUser.append("]");
        return positionUser.toString();
    }

    @RequestMapping(value={"router/boundaries-by-type", "escalation/boundaries-by-type"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Boundary> getBoundariesbyType(@RequestParam String boundaryName, @RequestParam Long boundaryTypeId, HttpServletResponse response) throws IOException {
        String likeBoundaryName = "%" + boundaryName + "%";
        return this.boundaryService.getBondariesByNameAndType(likeBoundaryName, boundaryTypeId);
    }
}

