/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.contract;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.egov.search.domain.Filter;
import org.egov.search.domain.Filters;
import org.jboss.logging.Logger;

public class ComplaintSearchRequest {
    private String searchText;
    private String complaintNumber;
    private String complainantName;
    private String complaintStatus;
    private String complainantPhoneNumber;
    private String complainantEmail;
    private String receivingCenter;
    private String complaintType;
    private String complaintDateFrom;
    private String complaintDateTo;
    private String fromDate;
    private String toDate;
    private String complaintDepartment;
    private String location;
    private String currentUlb;
    SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
    SimpleDateFormat dtft = new SimpleDateFormat("dd/MM/yyyy");
    private static final Logger logger = Logger.getLogger(ComplaintSearchRequest.class);

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public void setComplaintNumber(String complaintNumber) {
        this.complaintNumber = complaintNumber;
    }

    public void setCurrentUlb(String currentUlb) {
        this.currentUlb = currentUlb;
    }

    public void setComplaintStatus(String complaintStatus) {
        this.complaintStatus = complaintStatus;
    }

    public void setComplainantName(String complainantName) {
        this.complainantName = complainantName;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setComplainantPhoneNumber(String phoneNumber) {
        this.complainantPhoneNumber = phoneNumber;
    }

    public void setComplainantEmail(String email) {
        this.complainantEmail = email;
    }

    public void setReceivingCenter(String receivingCenter) {
        this.receivingCenter = receivingCenter;
    }

    public void setComplaintType(String complaintType) {
        this.complaintType = complaintType;
    }

    public void setFromDate(String fromDate) {
        if (null != fromDate) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Date Range From start.. :" + this.ft.format(this.dtft.parse(fromDate))));
                }
                this.fromDate = this.ft.format(this.dtft.parse(fromDate));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    public void setToDate(String toDate) {
        if (null != toDate) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Date Range Till .. :" + this.ft.format(this.dtft.parse(toDate))));
                }
                this.toDate = this.ft.format(this.dtft.parse(toDate));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    public void setComplaintDepartment(String complaintDepartment) {
        this.complaintDepartment = complaintDepartment;
    }

    public void setComplaintDate(String complaintDate) {
        if (null != complaintDate) {
            Date today = new Date();
            Calendar cal = Calendar.getInstance();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("String today date... " + this.ft.format(today)));
            }
            this.complaintDateTo = this.ft.format(today);
            if (complaintDate.equalsIgnoreCase("today")) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"This is today selection");
                }
                this.complaintDateFrom = this.complaintDateTo;
            } else if (complaintDate.equalsIgnoreCase("all")) {
                this.complaintDateFrom = null;
                this.complaintDateTo = null;
            } else if (complaintDate.equalsIgnoreCase("lastsevendays")) {
                cal.add(5, -6);
                this.complaintDateFrom = this.ft.format(cal.getTime());
            } else if (complaintDate.equalsIgnoreCase("lastthirtydays")) {
                cal.add(5, -29);
                this.complaintDateFrom = this.ft.format(cal.getTime());
            } else if (complaintDate.equalsIgnoreCase("lastninetydays")) {
                cal.add(5, -89);
                this.complaintDateFrom = this.ft.format(cal.getTime());
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Else section in date range");
                }
                this.complaintDateFrom = null;
                this.complaintDateTo = null;
            }
        }
    }

    public Filters searchFilters() {
        ArrayList<Filter> andFilters = new ArrayList<Filter>();
        andFilters.add(Filter.termsStringFilter((String)"clauses.citydetails.name", (String[])new String[]{this.currentUlb}));
        andFilters.add(Filter.termsStringFilter((String)"clauses.crn", (String[])new String[]{this.complaintNumber}));
        andFilters.add(Filter.queryStringFilter((String)"common.citizen.name", (String)this.complainantName));
        andFilters.add(Filter.queryStringFilter((String)"common.citizen.mobile", (String)this.complainantPhoneNumber));
        andFilters.add(Filter.queryStringFilter((String)"common.citizen.email", (String)this.complainantEmail));
        andFilters.add(Filter.queryStringFilter((String)"clauses.status.name", (String)this.complaintStatus));
        andFilters.add(Filter.queryStringFilter((String)"clauses.receivingMode", (String)this.receivingCenter));
        andFilters.add(Filter.queryStringFilter((String)"searchable.complaintType.name", (String)this.complaintType));
        andFilters.add(Filter.rangeFilter((String)"common.createdDate", (String)this.complaintDateFrom, (String)this.complaintDateTo));
        andFilters.add(Filter.rangeFilter((String)"common.createdDate", (String)this.fromDate, (String)this.toDate));
        andFilters.add(Filter.termsStringFilter((String)"clauses.department.name", (String[])new String[]{this.complaintDepartment}));
        andFilters.add(Filter.queryStringFilter((String)"common.boundary.name", (String)this.location));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"finished filters");
        }
        return Filters.withAndFilters(andFilters);
    }

    public String searchQuery() {
        return this.searchText;
    }
}

