/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.StringUtils;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.ApplicationNumberGenerator;
import org.egov.pgr.entity.Complaint;
import org.egov.pgr.repository.ComplaintRepository;
import org.egov.pgr.service.CitizenComplaintDataPublisher;
import org.egov.pgr.service.ComplaintMessagingService;
import org.egov.pgr.service.ComplaintProcessFlowService;
import org.egov.pgr.service.ComplaintStatusService;
import org.egov.pgr.service.PriorityService;
import org.egov.pgr.service.es.ComplaintIndexService;
import org.egov.pgr.utils.constants.PGRConstants;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ComplaintService {
    @Value(value="${complaint.default.priority}")
    private String defaultComplaintPriority;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private ComplaintRepository complaintRepository;
    @Autowired
    private ComplaintStatusService complaintStatusService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private ApplicationNumberGenerator applicationNumberGenerator;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private ComplaintIndexService complaintIndexService;
    @Autowired
    private PriorityService priorityService;
    @Autowired
    private ComplaintMessagingService complaintMessagingService;
    @Autowired
    private ComplaintProcessFlowService complaintProcessFlowService;
    @Autowired
    private CitizenComplaintDataPublisher citizenComplaintDataPublisher;

    @Transactional
    public Complaint createComplaint(Complaint complaint) {
        Boundary location;
        if (StringUtils.isBlank((String)complaint.getCrn())) {
            complaint.setCrn(this.applicationNumberGenerator.generate());
        }
        complaint.setStatus(this.complaintStatusService.getByName("REGISTERED"));
        User user = this.securityUtils.getCurrentUser();
        complaint.getComplainant().setUserDetail(user);
        if (this.securityUtils.currentUserIsCitizen()) {
            complaint.getComplainant().setEmail(user.getEmailId());
            complaint.getComplainant().setName(user.getName());
            complaint.getComplainant().setMobile(user.getMobileNumber());
        }
        if (complaint.getLocation() == null && complaint.hasGeoCoordinates() && (location = this.boundaryService.getBoundaryByGisCoordinates(Double.valueOf(complaint.getLat()), Double.valueOf(complaint.getLng()))) != null) {
            complaint.setLocation(location);
        }
        this.complaintProcessFlowService.onRegistration(complaint);
        if (complaint.getComplaintType().getDepartment() != null) {
            complaint.setDepartment(complaint.getComplaintType().getDepartment());
        } else {
            complaint.setDepartment(complaint.getAssignee().getDeptDesig().getDepartment());
        }
        if (complaint.getPriority() == null) {
            complaint.setPriority(this.priorityService.getPriorityByCode(this.defaultComplaintPriority));
        }
        this.complaintRepository.saveAndFlush((Object)complaint);
        this.complaintIndexService.createComplaintIndex(complaint);
        if (this.securityUtils.currentUserIsCitizen()) {
            this.citizenComplaintDataPublisher.onRegistration(complaint);
        }
        this.complaintMessagingService.sendRegistrationMessage(complaint);
        return complaint;
    }

    @Transactional
    public Complaint updateComplaint(Complaint complaint) {
        this.complaintProcessFlowService.onUpdation(complaint);
        this.complaintRepository.saveAndFlush((Object)complaint);
        this.complaintIndexService.updateComplaintIndex(complaint);
        this.citizenComplaintDataPublisher.onUpdation(complaint);
        this.complaintMessagingService.sendUpdateMessage(complaint);
        return complaint;
    }

    public Complaint getComplaintById(Long complaintID) {
        return (Complaint)((Object)this.complaintRepository.findOne(complaintID));
    }

    public Complaint getComplaintByCRN(String crn) {
        return this.complaintRepository.findByCrn(crn);
    }

    @ReadOnly
    public Page<Complaint> getLatest(int page, int pageSize) {
        return this.complaintRepository.findByCreatedByIdNotOrderByCreatedDateDesc(ApplicationThreadLocals.getUserId(), (Pageable)new PageRequest(page - 1, pageSize));
    }

    @ReadOnly
    public Page<Complaint> getMyComplaint(int page, int pageSize) {
        return this.complaintRepository.findByCreatedByIdOrderByCreatedDateDesc(ApplicationThreadLocals.getUserId(), (Pageable)new PageRequest(page - 1, pageSize));
    }

    @ReadOnly
    public List<Complaint> getNearByComplaint(int page, int pageSize, float lat, float lng, long distance) {
        return this.complaintRepository.findByNearestComplaint(ApplicationThreadLocals.getUserId(), Float.valueOf(lat), Float.valueOf(lng), distance, (long)pageSize + 1L, ((long)page - 1L) * (long)pageSize);
    }

    @ReadOnly
    public List<Complaint> getPendingGrievances() {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(Complaint.class, "complaint").createAlias("complaint.state", "state").createAlias("complaint.status", "status");
        criteria.add(Restrictions.in((String)"status.name", (Object[])PGRConstants.PENDING_STATUS));
        criteria.add(Restrictions.in((String)"complaint.assignee", (Collection)this.positionMasterService.getPositionsForEmployee(ApplicationThreadLocals.getUserId(), new Date())));
        return criteria.list();
    }

    @ReadOnly
    public Page<Complaint> getMyPendingGrievances(int page, int pageSize) {
        return this.complaintRepository.findByCreatedByIdAndStatusNameInOrderByCreatedDateDesc(ApplicationThreadLocals.getUserId(), PGRConstants.PENDING_STATUS, (Pageable)new PageRequest(page - 1, pageSize));
    }

    @ReadOnly
    public Page<Complaint> getMyCompletedGrievances(int page, int pageSize) {
        return this.complaintRepository.findByCreatedByIdAndStatusNameInOrderByCreatedDateDesc(ApplicationThreadLocals.getUserId(), PGRConstants.COMPLETED_STATUS, (Pageable)new PageRequest(page - 1, pageSize));
    }

    @ReadOnly
    public Page<Complaint> getMyRejectedGrievances(int page, int pageSize) {
        return this.complaintRepository.findByCreatedByIdAndStatusNameInOrderByCreatedDateDesc(ApplicationThreadLocals.getUserId(), PGRConstants.REJECTED_STATUS, (Pageable)new PageRequest(page - 1, pageSize));
    }

    @ReadOnly
    public Map<String, Long> getMyComplaintsCount() {
        HashMap<String, Long> complaintsCount = new HashMap<String, Long>();
        complaintsCount.put("ALL", this.complaintRepository.countByCreatedById(ApplicationThreadLocals.getUserId()));
        complaintsCount.put("PENDING", this.complaintRepository.countByCreatedByIdAndStatusNameIn(ApplicationThreadLocals.getUserId(), PGRConstants.PENDING_STATUS));
        complaintsCount.put("COMPLETED", this.complaintRepository.countByCreatedByIdAndStatusNameIn(ApplicationThreadLocals.getUserId(), PGRConstants.COMPLETED_STATUS));
        complaintsCount.put("REJECTED", this.complaintRepository.countByCreatedByIdAndStatusNameIn(ApplicationThreadLocals.getUserId(), PGRConstants.REJECTED_STATUS));
        return complaintsCount;
    }

    @ReadOnly
    public Map<String, Long> getComplaintsTotalCount() {
        HashMap<String, Long> complaintsCount = new HashMap<String, Long>();
        complaintsCount.put("FILED", this.complaintRepository.count());
        complaintsCount.put("RESOLVED", this.complaintRepository.countByStatusNameIn(PGRConstants.RESOLVED_STATUS));
        complaintsCount.put("UNRESOLVED", this.complaintRepository.countByStatusNameIn(PGRConstants.PENDING_STATUS));
        return complaintsCount;
    }

    @ReadOnly
    public List<Complaint> getOpenComplaints() {
        return this.complaintRepository.findByStatusNameIn(Arrays.asList(PGRConstants.PENDING_STATUS));
    }
}

