/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.service;

import java.util.Date;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.pgr.entity.Complaint;
import org.egov.pgr.service.ComplaintEscalationService;
import org.egov.pgr.service.ComplaintRouterService;
import org.egov.pgr.service.ForwardSkippablePositionService;
import org.egov.pims.commons.Position;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ComplaintProcessFlowService {
    private static final String GRIEVANCE_REG_COMMENT = "Grievance registered with CRN : %s";
    @Autowired
    private ComplaintEscalationService escalationService;
    @Autowired
    private ComplaintRouterService complaintRouterService;
    @Autowired
    private ForwardSkippablePositionService forwardSkippablePositionService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private PositionMasterService positionMasterService;

    public void onRegistration(Complaint complaint) {
        Position assignee = this.complaintRouterService.getAssignee(complaint);
        complaint.transition().start().withSenderName(complaint.getComplainant().getName()).withComments(String.format(GRIEVANCE_REG_COMMENT, complaint.getCrn())).withStateValue(complaint.getStatus().getName()).withOwner(assignee).withDateInfo(new Date());
        complaint.setAssignee(assignee);
        complaint.setEscalationDate(this.escalationService.getExpiryDate(complaint));
    }

    public void onUpdation(Complaint complaint) {
        User currentUser = this.securityUtils.getCurrentUser();
        String userName = this.securityUtils.currentUserIsCitizen() ? currentUser.getName() : currentUser.getUsername() + "::" + currentUser.getName();
        if (!complaint.transitionCompleted() && complaint.completed()) {
            complaint.setDepartment(complaint.getAssignee().getDeptDesig().getDepartment());
            if (!currentUser.hasRole("Grievance Officer")) {
                complaint.transition().end().withComments(complaint.approverComment()).withStateValue(complaint.getStatus().getName()).withSenderName(userName).withDateInfo(new Date());
            } else {
                complaint.transition().end().withComments(complaint.approverComment()).withStateValue(complaint.getStatus().getName()).withSenderName(userName).withDateInfo(new Date()).withOwner(complaint.getState().getOwnerPosition());
            }
        } else if (complaint.hasNextOwner()) {
            Position owner = this.positionMasterService.getPositionById(complaint.nextOwnerId());
            complaint.setAssignee(owner);
            complaint.setDepartment(complaint.getAssignee().getDeptDesig().getDepartment());
            complaint.transition().progressWithStateCopy().withOwner(owner).withComments(complaint.approverComment()).withSenderName(userName).withStateValue(complaint.getStatus().getName()).withDateInfo(new Date());
        } else if (complaint.sendToPreviousOwner() && this.canSendToPreviousAssignee(complaint)) {
            Position nextAssignee = complaint.previousAssignee();
            complaint.setDepartment(nextAssignee.getDeptDesig().getDepartment());
            complaint.setAssignee(nextAssignee);
            complaint.transition().progressWithStateCopy().withComments(complaint.approverComment()).withSenderName(userName).withStateValue(complaint.getStatus().getName()).withOwner(nextAssignee).withDateInfo(new Date());
        } else if (complaint.reopened()) {
            complaint.transition().reopen().withComments(complaint.approverComment()).withSenderName(userName).withStateValue(complaint.getStatus().getName()).withDateInfo(new Date());
        } else if (complaint.inprogress()) {
            complaint.transition().progressWithStateCopy().withComments(complaint.approverComment()).withSenderName(userName).withStateValue(complaint.getStatus().getName()).withDateInfo(new Date());
        }
    }

    public boolean canSendToPreviousAssignee(Complaint complaint) {
        return complaint.hasState() && complaint.previousAssignee() != null && this.forwardSkippablePositionService.isSkippablePosition(complaint.currentAssignee());
    }
}

