/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.service;

import java.util.Arrays;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.pgr.entity.Complaint;
import org.egov.portal.entity.PortalInboxBuilder;
import org.egov.portal.service.PortalInboxService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CitizenComplaintDataPublisher {
    private static final String COMPLAINT_UPDATE_URL = "/pgr/complaint/update/%s";
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private PortalInboxService portalInboxService;
    @Autowired
    private SecurityUtils securityUtils;
    @Value(value="${default.resolution.time}")
    private Integer defaultSLAHours;

    public void onRegistration(Complaint complaint) {
        Integer slaHours = complaint.getComplaintType().getSlaHours();
        String messageHeader = "REGISTERED".equals(complaint.getStatus().getName()) ? "Grievance Recorded" : "Grievance Redressal";
        StringBuilder detailedMessage = new StringBuilder().append("Complaint Type : ").append(complaint.getComplaintType().getName()).append(" in ").append(complaint.getLocation().getName());
        PortalInboxBuilder portalInboxBuilder = new PortalInboxBuilder(this.moduleService.getModuleByName("PGR"), complaint.getStateType(), complaint.getCrn(), complaint.getCrn(), complaint.getId(), messageHeader, detailedMessage.toString(), String.format(COMPLAINT_UPDATE_URL, complaint.getCrn()), false, complaint.getStatus().getName(), DateUtils.addHours((Date)new Date(), (int)(slaHours == null ? this.defaultSLAHours : slaHours)), complaint.getState(), Arrays.asList(this.securityUtils.getCurrentUser()));
        this.portalInboxService.pushInboxMessage(portalInboxBuilder.build());
    }

    public void onUpdation(Complaint complaint) {
        this.portalInboxService.updateInboxMessage(complaint.getCrn(), this.moduleService.getModuleByName("PGR").getId(), complaint.getStatus().getName(), Boolean.valueOf(complaint.completed()), null, complaint.getState(), complaint.getCreatedBy(), complaint.getCrn(), String.format(COMPLAINT_UPDATE_URL, complaint.getCrn()));
    }
}

